/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.lastaflute.di.exception.IORuntimeException;
import org.lastaflute.di.util.LdiFileUtil;
import org.lastaflute.di.util.LdiURLUtil;

public class LdiZipFileUtil {
    protected LdiZipFileUtil() {
    }

    public static ZipFile create(String file) {
        try {
            return new ZipFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ZipFile create(File file) {
        try {
            return new ZipFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream getInputStream(ZipFile file, ZipEntry entry) {
        try {
            return file.getInputStream(entry);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ZipFile toZipFile(URL zipUrl) {
        return LdiZipFileUtil.create(new File(LdiZipFileUtil.toZipFilePath(zipUrl)));
    }

    public static String toZipFilePath(URL zipUrl) {
        String urlString = zipUrl.getPath();
        int pos = urlString.lastIndexOf(33);
        String zipFilePath = urlString.substring(0, pos);
        File zipFile = new File(LdiURLUtil.decode(zipFilePath, "UTF8"));
        return LdiFileUtil.getCanonicalPath(zipFile);
    }

    public static void close(ZipFile zipFile) {
        try {
            zipFile.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

