/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.core.xa;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    static final long serialVersionUID = 1L;
    private static final int FORMAT_ID = 4360;
    private static final byte[] INITIAL_BRANCH_ID = XidImpl.convert64bytes(new byte[0]);
    private static final String GLOBAL_ID_BASE = System.currentTimeMillis() + "/";
    private static int nextId = 0;
    private int hashCode;
    private byte[] globalId;
    private byte[] branchId;

    public XidImpl() {
        this.hashCode = XidImpl.getNextId();
        this.globalId = this.createGlobalId();
        this.branchId = INITIAL_BRANCH_ID;
    }

    public XidImpl(Xid xid, int bid) {
        this.hashCode = xid.hashCode();
        this.globalId = xid.getGlobalTransactionId();
        this.branchId = XidImpl.convert64bytes(Integer.toString(bid).getBytes());
    }

    private byte[] createGlobalId() {
        return XidImpl.convert64bytes((GLOBAL_ID_BASE + Integer.toString(this.hashCode)).getBytes());
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        return (byte[])this.branchId.clone();
    }

    @Override
    public int getFormatId() {
        return 4360;
    }

    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof XidImpl)) {
            return false;
        }
        XidImpl other = (XidImpl)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (this.globalId.length != other.globalId.length || this.branchId.length != other.branchId.length) {
            return false;
        }
        for (i = 0; i < this.globalId.length; ++i) {
            if (this.globalId[i] == other.globalId[i]) continue;
            return false;
        }
        for (i = 0; i < this.branchId.length; ++i) {
            if (this.branchId[i] == other.branchId[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "[FormatId=4360, GlobalId=" + new String(this.globalId).trim() + ", BranchId=" + new String(this.branchId).trim() + "]";
    }

    private static byte[] convert64bytes(byte[] bytes) {
        byte[] new64bytes = new byte[64];
        System.arraycopy(bytes, 0, new64bytes, 0, bytes.length);
        return new64bytes;
    }

    private static synchronized int getNextId() {
        return nextId++;
    }
}

