/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.autoregister;

import java.util.ArrayList;
import java.util.List;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.autoregister.ClassPattern;

public abstract class AbstractAutoRegister {
    public static final String INIT_METHOD = "registerAll";
    private LaContainer container;
    private final List<ClassPattern> classPatterns = new ArrayList<ClassPattern>();
    private final List<ClassPattern> ignoreClassPatterns = new ArrayList<ClassPattern>();

    public LaContainer getContainer() {
        return this.container;
    }

    public void setContainer(LaContainer container) {
        this.container = container;
    }

    public int getClassPatternSize() {
        return this.classPatterns.size();
    }

    public ClassPattern getClassPattern(int index) {
        return this.classPatterns.get(index);
    }

    public void addClassPattern(String packageName, String shortClassNames) {
        this.addClassPattern(new ClassPattern(packageName, shortClassNames));
    }

    public void addClassPattern(ClassPattern classPattern) {
        this.classPatterns.add(classPattern);
    }

    public void addIgnoreClassPattern(String packageName, String shortClassNames) {
        this.addIgnoreClassPattern(new ClassPattern(packageName, shortClassNames));
    }

    public void addIgnoreClassPattern(ClassPattern classPattern) {
        this.ignoreClassPatterns.add(classPattern);
    }

    public abstract void registerAll();

    protected boolean hasComponentDef(String name) {
        return this.findComponentDef(name) != null;
    }

    protected ComponentDef findComponentDef(String name) {
        if (name == null) {
            return null;
        }
        LaContainer container = this.getContainer();
        for (int i = 0; i < container.getComponentDefSize(); ++i) {
            ComponentDef cd = container.getComponentDef(i);
            if (!name.equals(cd.getComponentName())) continue;
            return cd;
        }
        return null;
    }

    protected boolean isIgnore(String packageName, String shortClassName) {
        if (this.ignoreClassPatterns.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.ignoreClassPatterns.size(); ++i) {
            ClassPattern cp = this.ignoreClassPatterns.get(i);
            if (!cp.isAppliedPackageName(packageName) || !cp.isAppliedShortClassName(shortClassName)) continue;
            return true;
        }
        return false;
    }
}

