/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.defbuilder.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.annotation.Aspect;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandler;
import org.lastaflute.di.core.factory.defbuilder.impl.AbstractAspectDefBuilder;

public class AspectAnnotationAspectDefBuilder
extends AbstractAspectDefBuilder {
    @Override
    public void appendAspectDef(AnnotationHandler annotationHandler, ComponentDef componentDef) {
        this.processClass(componentDef);
        this.processMethod(componentDef);
    }

    protected void processClass(ComponentDef componentDef) {
        Class<?> componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        Aspect aspect = componentClass.getAnnotation(Aspect.class);
        if (aspect != null) {
            String interceptor = aspect.value();
            String pointcut = aspect.pointcut();
            this.appendAspect(componentDef, interceptor, pointcut);
        }
    }

    protected void processMethod(ComponentDef componentDef) {
        Method[] methods;
        Class<?> componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        for (Method method : methods = componentClass.getMethods()) {
            Aspect aspect;
            int modifiers;
            if (method.isBridge() || method.isSynthetic() || !Modifier.isPublic(modifiers = method.getModifiers()) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || (aspect = method.getAnnotation(Aspect.class)) == null) continue;
            String interceptor = aspect.value();
            this.appendAspect(componentDef, interceptor, method);
        }
    }
}

