/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.smart.hot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.lastaflute.di.core.meta.impl.LaContainerBehavior;
import org.lastaflute.di.core.smart.hot.HotdeployBehavior;
import org.lastaflute.di.util.LdiClassLoaderUtil;
import org.lastaflute.di.util.LdiClassUtil;

public class HotdeployUtil {
    public static final String REBUILDER_CLASS_NAME = HotdeployUtil.class.getName() + "$RebuilderImpl";

    protected HotdeployUtil() {
    }

    public static HotdeployBehavior getHotdeployBehavior() {
        if (HotdeployUtil.isHotdeploy()) {
            return (HotdeployBehavior)LaContainerBehavior.getProvider();
        }
        return null;
    }

    public static boolean isHotdeploy() {
        return LaContainerBehavior.getProvider() instanceof HotdeployBehavior;
    }

    public static boolean isAlreadyHotdeploy() {
        return HotdeployUtil.isHotdeploy() && HotdeployUtil.getHotdeployBehavior().isAlreadyHotdeploy();
    }

    public static void start() {
        if (HotdeployUtil.isHotdeploy() && !HotdeployUtil.isAlreadyHotdeploy()) {
            HotdeployUtil.getHotdeployBehavior().start();
        }
    }

    public static void stop() {
        if (HotdeployUtil.isHotdeploy() && HotdeployUtil.isAlreadyHotdeploy()) {
            HotdeployUtil.getHotdeployBehavior().stop();
        }
    }

    public static Object deserializeInternal(byte[] bytes) throws Exception {
        if (bytes == null) {
            return null;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> rebuilderClass = LdiClassLoaderUtil.loadClass(loader, REBUILDER_CLASS_NAME);
        Rebuilder rebuilder = (Rebuilder)LdiClassUtil.newInstance(rebuilderClass);
        return rebuilder.deserialize(bytes);
    }

    public static Object rebuildValue(Object value) {
        if (HotdeployUtil.isHotdeploy()) {
            return HotdeployUtil.rebuildValueInternal(value);
        }
        return value;
    }

    protected static Object rebuildValueInternal(Object value) {
        if (value == null) {
            return null;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> rebuilderClass = LdiClassLoaderUtil.loadClass(loader, REBUILDER_CLASS_NAME);
        Rebuilder rebuilder = (Rebuilder)LdiClassUtil.newInstance(rebuilderClass);
        return rebuilder.rebuild(value);
    }

    public static class RebuilderImpl
    implements Rebuilder {
        @Override
        public Object rebuild(Object value) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(value);
                oos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(bais);
                return ois.readObject();
            }
            catch (Throwable t) {
                return value;
            }
        }

        @Override
        public Object deserialize(byte[] bytes) throws Exception {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
    }

    public static interface Rebuilder {
        public Object rebuild(Object var1);

        public Object deserialize(byte[] var1) throws Exception;
    }
}

