/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.tx;

import org.lastaflute.di.exception.SIllegalArgumentException;
import org.lastaflute.di.tx.TransactionManagerAdapter;

public class TxRule {
    protected final Class<?> exceptionClass;
    protected final boolean commit;

    public TxRule(Class<?> exceptionClass, boolean commit) {
        if (!Throwable.class.isAssignableFrom(exceptionClass)) {
            throw new SIllegalArgumentException("ESSR0365", new Object[]{exceptionClass.getName()});
        }
        this.exceptionClass = exceptionClass;
        this.commit = commit;
    }

    public boolean isAssignableFrom(Throwable cause) {
        return this.exceptionClass.isAssignableFrom(cause.getClass());
    }

    public void complete(TransactionManagerAdapter adapter) {
        if (!this.commit) {
            adapter.setRollbackOnly();
        }
    }
}

