/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.customizer;

import java.util.ArrayList;
import java.util.List;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.customizer.AbstractCustomizer;
import org.lastaflute.di.core.customizer.AspectCustomizer;
import org.lastaflute.di.core.customizer.ComponentCustomizer;

public class CustomizerChain
extends AbstractCustomizer {
    private final List<ComponentCustomizer> customizers = new ArrayList<ComponentCustomizer>();

    public int getCustomizerSize() {
        return this.customizers.size();
    }

    public ComponentCustomizer getCustomizer(int index) {
        return this.customizers.get(index);
    }

    public void addCustomizer(ComponentCustomizer customizer) {
        this.customizers.add(customizer);
    }

    public void addAspectCustomizer(String interceptorName) {
        AspectCustomizer customizer = this.newAspectCustomizer();
        customizer.setInterceptorName(interceptorName);
        this.addCustomizer(customizer);
    }

    public void addAspectCustomizer(String interceptorName, String pointcut) {
        AspectCustomizer customizer = this.newAspectCustomizer();
        customizer.setInterceptorName(interceptorName);
        customizer.setPointcut(pointcut);
        this.addCustomizer(customizer);
    }

    public void addAspectCustomizer(String interceptorName, boolean useLookupAdapter) {
        AspectCustomizer customizer = this.newAspectCustomizer();
        customizer.setInterceptorName(interceptorName);
        customizer.setUseLookupAdapter(useLookupAdapter);
        this.addCustomizer(customizer);
    }

    public void addAspectCustomizer(String interceptorName, String pointcut, boolean useLookupAdapter) {
        AspectCustomizer customizer = this.newAspectCustomizer();
        customizer.setInterceptorName(interceptorName);
        customizer.setPointcut(pointcut);
        customizer.setUseLookupAdapter(useLookupAdapter);
        this.addCustomizer(customizer);
    }

    protected AspectCustomizer newAspectCustomizer() {
        return new AspectCustomizer();
    }

    @Override
    protected void doCustomize(ComponentDef componentDef) {
        for (int i = 0; i < this.getCustomizerSize(); ++i) {
            ComponentCustomizer customizer = this.getCustomizer(i);
            customizer.customize(componentDef);
        }
    }
}

