/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.defbuilder.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.assembler.AccessTypeDefFactory;
import org.lastaflute.di.core.assembler.BindingTypeDefFactory;
import org.lastaflute.di.core.expression.ScriptingExpression;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandler;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandlerFactory;
import org.lastaflute.di.core.factory.defbuilder.PropertyDefBuilder;
import org.lastaflute.di.core.meta.AccessTypeDef;
import org.lastaflute.di.core.meta.InstanceDef;
import org.lastaflute.di.core.meta.PropertyDef;
import org.lastaflute.di.core.meta.impl.InstanceDefFactory;
import org.lastaflute.di.core.meta.impl.PropertyDefImpl;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.PropertyDesc;
import org.lastaflute.di.util.LdiStringUtil;

public abstract class AbstractPropertyDefBuilder<ANNO extends Annotation>
implements PropertyDefBuilder {
    protected final AnnotationHandler handler = AnnotationHandlerFactory.getAnnotationHandler();

    @Override
    public PropertyDef createPropertyDef(AnnotationHandler annotationHandler, BeanDesc beanDesc, PropertyDesc propertyDesc) {
        if (!propertyDesc.hasWriteMethod()) {
            return null;
        }
        Method method = propertyDesc.getWriteMethod();
        ANNO annotation = method.getAnnotation(this.getAnnotationType());
        return annotation != null ? this.createPropertyDef(propertyDesc.getPropertyName(), AccessTypeDefFactory.PROPERTY, annotation) : null;
    }

    @Override
    public PropertyDef createPropertyDef(AnnotationHandler annotationHandler, BeanDesc beanDesc, Field field) {
        ANNO annotation = field.getAnnotation(this.getAnnotationType());
        return annotation != null ? this.createPropertyDef(field.getName(), AccessTypeDefFactory.FIELD, annotation) : null;
    }

    protected abstract Class<ANNO> getAnnotationType();

    protected abstract PropertyDef createPropertyDef(String var1, AccessTypeDef var2, ANNO var3);

    protected ComponentDef createComponentDef(Class<?> componentClass) {
        return this.createComponentDef(componentClass, InstanceDefFactory.SINGLETON);
    }

    protected ComponentDef createComponentDef(Class<?> componentClass, InstanceDef instanceDef) {
        ComponentDef componentDef = this.handler.createComponentDef(componentClass, instanceDef);
        this.handler.appendDI(componentDef);
        this.handler.appendAspect(componentDef);
        this.handler.appendInterType(componentDef);
        this.handler.appendInitMethod(componentDef);
        this.handler.appendDestroyMethod(componentDef);
        return componentDef;
    }

    protected PropertyDef createPropertyDef(String propertyName, AccessTypeDef accessTypeDef) {
        return this.createPropertyDef(propertyName, accessTypeDef, "");
    }

    protected PropertyDef createPropertyDef(String propertyName, AccessTypeDef accessTypeDef, String expression) {
        return this.createPropertyDef(propertyName, accessTypeDef, expression, null);
    }

    protected PropertyDef createPropertyDef(String propertyName, AccessTypeDef accessTypeDef, ComponentDef child) {
        return this.createPropertyDef(propertyName, accessTypeDef, "", child);
    }

    protected PropertyDef createPropertyDef(String propertyName, AccessTypeDef accessTypeDef, String expression, ComponentDef child) {
        PropertyDefImpl propertyDef = new PropertyDefImpl(propertyName);
        propertyDef.setAccessTypeDef(accessTypeDef);
        propertyDef.setBindingTypeDef(BindingTypeDefFactory.MUST);
        if (!LdiStringUtil.isEmpty(expression)) {
            propertyDef.setExpression(new ScriptingExpression(expression));
        }
        if (child != null) {
            propertyDef.setChildComponentDef(child);
        }
        return propertyDef;
    }
}

