/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.assembler;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.assembler.AbstractAssembler;
import org.lastaflute.di.core.assembler.MethodAssembler;
import org.lastaflute.di.core.exception.ComponentNotFoundException;
import org.lastaflute.di.core.exception.IllegalMethodRuntimeException;
import org.lastaflute.di.core.meta.MethodDef;
import org.lastaflute.di.core.util.BindingUtil;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.util.LdiMethodUtil;

public abstract class AbstractMethodAssembler
extends AbstractAssembler
implements MethodAssembler {
    public AbstractMethodAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    protected void invoke(BeanDesc beanDesc, Object component, MethodDef methodDef) throws IllegalMethodRuntimeException {
        Method method = methodDef.getMethod();
        if (method != null) {
            if (!Modifier.isPublic(method.getModifiers()) && !method.isAccessible()) {
                method.setAccessible(true);
            }
            try {
                LdiMethodUtil.invoke(method, component, methodDef.getArgs());
            }
            catch (Exception cause) {
                throw new IllegalMethodRuntimeException(this.getComponentClass(component), method.getName(), (Throwable)cause);
            }
            return;
        }
        String methodName = methodDef.getMethodName();
        if (methodName != null) {
            Object[] args = null;
            try {
                if (methodDef.getArgDefSize() > 0) {
                    args = methodDef.getArgs();
                } else {
                    Method[] methods = beanDesc.getMethods(methodName);
                    method = this.getSuitableMethod(methods);
                    if (method != null) {
                        args = this.getArgs(method.getParameterTypes());
                    }
                }
            }
            catch (ComponentNotFoundException cause) {
                throw new IllegalMethodRuntimeException(this.getComponentClass(component), methodName, (Throwable)cause);
            }
            if (method != null) {
                LdiMethodUtil.invoke(method, component, args);
            } else {
                this.invoke(beanDesc, component, methodName, args);
            }
            return;
        }
        this.invokeExpression(component, methodDef);
    }

    private void invokeExpression(Object component, MethodDef methodDef) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("self", component);
        ctx.put("out", System.out);
        ctx.put("err", System.err);
        LaContainer container = this.getComponentDef().getContainer();
        methodDef.getExpression().evaluate(ctx, container, Object.class);
    }

    private Method getSuitableMethod(Method[] methods) {
        int argSize = -1;
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            int tempArgSize = methods[i].getParameterTypes().length;
            if (tempArgSize <= argSize || !BindingUtil.isPropertyAutoBindable(methods[i].getParameterTypes())) continue;
            method = methods[i];
            argSize = tempArgSize;
        }
        return method;
    }

    private void invoke(BeanDesc beanDesc, Object component, String methodName, Object[] args) throws IllegalMethodRuntimeException {
        try {
            beanDesc.invoke(component, methodName, args);
        }
        catch (NumberFormatException ex) {
            throw new IllegalMethodRuntimeException(this.getComponentDef().getComponentClass(), methodName, (Throwable)ex);
        }
    }
}

