/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.deployer;

import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.assembler.AssemblerFactory;
import org.lastaflute.di.core.assembler.ConstructorAssembler;
import org.lastaflute.di.core.assembler.MethodAssembler;
import org.lastaflute.di.core.assembler.PropertyAssembler;
import org.lastaflute.di.core.deployer.ComponentDeployer;
import org.lastaflute.di.core.meta.AutoBindingDef;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiStringUtil;

public abstract class AbstractComponentDeployer
implements ComponentDeployer {
    private ComponentDef componentDef;
    private ConstructorAssembler constructorAssembler;
    private PropertyAssembler propertyAssembler;
    private MethodAssembler initMethodAssembler;
    private MethodAssembler destroyMethodAssembler;

    public AbstractComponentDeployer(ComponentDef componentDef) {
        this.componentDef = componentDef;
        this.setupAssembler();
    }

    protected void setupAssembler() {
        AutoBindingDef autoBindingDef = this.componentDef.getAutoBindingDef();
        this.constructorAssembler = autoBindingDef.createConstructorAssembler(this.componentDef);
        this.propertyAssembler = autoBindingDef.createPropertyAssembler(this.componentDef);
        this.initMethodAssembler = AssemblerFactory.createInitMethodAssembler(this.componentDef);
        this.destroyMethodAssembler = AssemblerFactory.createDestroyMethodAssembler(this.componentDef);
    }

    protected String getComponentName() {
        String componentName = this.componentDef.getComponentName();
        if (componentName == null) {
            componentName = LdiClassUtil.getShortClassName(this.componentDef.getComponentClass());
            componentName = LdiStringUtil.decapitalize(componentName);
        }
        return componentName;
    }

    protected final ComponentDef getComponentDef() {
        return this.componentDef;
    }

    protected final ConstructorAssembler getConstructorAssembler() {
        return this.constructorAssembler;
    }

    protected final PropertyAssembler getPropertyAssembler() {
        return this.propertyAssembler;
    }

    protected final MethodAssembler getInitMethodAssembler() {
        return this.initMethodAssembler;
    }

    protected final MethodAssembler getDestroyMethodAssembler() {
        return this.destroyMethodAssembler;
    }
}

