/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.lastaflute.di.exception.IORuntimeException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LdiDomUtil {
    protected LdiDomUtil() {
    }

    public static InputStream getContentsAsStream(String contents) {
        return LdiDomUtil.getContentsAsStream(contents, null);
    }

    public static InputStream getContentsAsStream(String contents, String encoding) {
        if (encoding == null) {
            return new ByteArrayInputStream(contents.getBytes());
        }
        try {
            return new ByteArrayInputStream(contents.getBytes(encoding));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static String encodeAttrQuot(String s) {
        if (s == null) {
            return null;
        }
        char[] content = s.toCharArray();
        StringBuffer buf = new StringBuffer();
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                default: {
                    buf.append(content[i]);
                }
            }
        }
        return buf.toString();
    }

    public static String encodeText(String s) {
        if (s == null) {
            return null;
        }
        char[] content = s.toCharArray();
        StringBuffer buf = new StringBuffer();
        block5: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                default: {
                    buf.append(content[i]);
                }
            }
        }
        return buf.toString();
    }

    public static String toString(Document document) {
        StringBuffer buf = new StringBuffer();
        LdiDomUtil.appendElement(document.getDocumentElement(), buf);
        return buf.toString();
    }

    public static String toString(Element element) {
        StringBuffer buf = new StringBuffer();
        LdiDomUtil.appendElement(element, buf);
        return buf.toString();
    }

    public static void appendElement(Element element, StringBuffer buf) {
        String tag = element.getTagName();
        buf.append('<');
        buf.append(tag);
        LdiDomUtil.appendAttrs(element.getAttributes(), buf);
        buf.append('>');
        LdiDomUtil.appendChildren(element.getChildNodes(), buf);
        buf.append("</");
        buf.append(tag);
        buf.append('>');
    }

    public static void appendChildren(NodeList children, StringBuffer buf) {
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            LdiDomUtil.appendNode(children.item(i), buf);
        }
    }

    public static void appendAttrs(NamedNodeMap attrs, StringBuffer buf) {
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)attrs.item(i);
            buf.append(' ');
            LdiDomUtil.appendAttr(attr, buf);
        }
    }

    public static void appendAttr(Attr attr, StringBuffer buf) {
        buf.append(attr.getName());
        buf.append("=\"");
        buf.append(LdiDomUtil.encodeAttrQuot(attr.getValue()));
        buf.append('\"');
    }

    public static void appendText(Text text, StringBuffer buf) {
        buf.append(LdiDomUtil.encodeText(text.getData()));
    }

    public static void appendCDATASection(CDATASection cdataSection, StringBuffer buf) {
        buf.append("<![CDATA[");
        buf.append(cdataSection.getData());
        buf.append("]]>");
    }

    public static void appendEntityReference(EntityReference entityReference, StringBuffer buf) {
        buf.append('&');
        buf.append(entityReference.getNodeName());
        buf.append(';');
    }

    public static void appendNode(Node node, StringBuffer buf) {
        switch (node.getNodeType()) {
            case 1: {
                LdiDomUtil.appendElement((Element)node, buf);
                break;
            }
            case 3: {
                LdiDomUtil.appendText((Text)node, buf);
                break;
            }
            case 4: {
                LdiDomUtil.appendCDATASection((CDATASection)node, buf);
                break;
            }
            case 5: {
                LdiDomUtil.appendEntityReference((EntityReference)node, buf);
            }
        }
    }
}

