/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.lastaflute.di.exception.IORuntimeException;
import org.lastaflute.di.util.LdiAssertionUtil;
import org.lastaflute.di.util.LdiResourceUtil;

public class LdiMimeTypeUtil {
    protected LdiMimeTypeUtil() {
    }

    public static String guessContentType(String path) {
        LdiAssertionUtil.assertNotNull("path is null.", path);
        InputStream is = LdiResourceUtil.getResourceAsStream(path);
        String mimetype = null;
        try {
            mimetype = URLConnection.guessContentTypeFromStream(is);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (mimetype == null) {
            mimetype = URLConnection.guessContentTypeFromName(path);
        }
        return mimetype;
    }
}

