/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.File;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.lastaflute.di.exception.SAXRuntimeException;
import org.lastaflute.di.util.LdiSchemaFactoryUtil;
import org.xml.sax.SAXException;

public abstract class LdiSchemaUtil {
    public static Schema newW3cXmlSchema(File schema) {
        return LdiSchemaUtil.newSchema(LdiSchemaFactoryUtil.newW3cXmlSchemaFactory(), schema);
    }

    public static Schema newW3cXmlSchema(Source schema) {
        return LdiSchemaUtil.newSchema(LdiSchemaFactoryUtil.newW3cXmlSchemaFactory(), schema);
    }

    public static Schema newW3cXmlSchema(URL schema) {
        return LdiSchemaUtil.newSchema(LdiSchemaFactoryUtil.newW3cXmlSchemaFactory(), schema);
    }

    public static Schema newRelaxNgSchema(File schema) {
        return LdiSchemaUtil.newSchema(LdiSchemaFactoryUtil.newRelaxNgSchemaFactory(), schema);
    }

    public static Schema newRelaxNgSchema(Source schema) {
        return LdiSchemaUtil.newSchema(LdiSchemaFactoryUtil.newRelaxNgSchemaFactory(), schema);
    }

    public static Schema newRelaxNgSchema(URL schema) {
        return LdiSchemaUtil.newSchema(LdiSchemaFactoryUtil.newRelaxNgSchemaFactory(), schema);
    }

    public static Schema newSchema(SchemaFactory factory, File schema) {
        try {
            return factory.newSchema(schema);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }

    public static Schema newSchema(SchemaFactory factory, Source schema) {
        try {
            return factory.newSchema(schema);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }

    public static Schema newSchema(SchemaFactory factory, URL schema) {
        try {
            return factory.newSchema(schema);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }
}

