/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.javassist;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.lastaflute.di.core.aop.javassist.AspectWeaver;
import org.lastaflute.di.core.util.ClassPoolUtil;
import org.lastaflute.di.exception.CannotCompileRuntimeException;
import org.lastaflute.di.exception.IORuntimeException;
import org.lastaflute.di.exception.IllegalAccessRuntimeException;
import org.lastaflute.di.exception.InvocationTargetRuntimeException;
import org.lastaflute.di.exception.NoSuchMethodRuntimeException;
import org.lastaflute.di.exception.NotFoundRuntimeException;
import org.lastaflute.di.util.LdiClassUtil;

public class AbstractGenerator {
    protected static final String DEFINE_CLASS_METHOD_NAME = "defineClass";
    protected static final ProtectionDomain protectionDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            return AspectWeaver.class.getProtectionDomain();
        }
    });
    protected static Method defineClassMethod;
    protected final ClassPool classPool;

    protected static String fromObject(Class<?> type, String expr) {
        if (type.equals(Void.TYPE) || type.equals(Object.class)) {
            return expr;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Character.TYPE)) {
            Class<?> wrapper = LdiClassUtil.getWrapperClass(type);
            return "((" + wrapper.getName() + ") " + expr + ")." + type.getName() + "Value()";
        }
        if (type.isPrimitive()) {
            return "((java.lang.Number) " + expr + ")." + type.getName() + "Value()";
        }
        return "(" + LdiClassUtil.getSimpleClassName(type) + ") " + expr;
    }

    protected static String toObject(Class<?> type, String expr) {
        if (type.isPrimitive()) {
            Class<?> wrapper = LdiClassUtil.getWrapperClass(type);
            return "new " + wrapper.getName() + "(" + expr + ")";
        }
        return expr;
    }

    protected AbstractGenerator(ClassPool classPool) {
        this.classPool = classPool;
    }

    protected CtClass toCtClass(Class<?> clazz) {
        return ClassPoolUtil.toCtClass(this.classPool, clazz);
    }

    protected CtClass toCtClass(String className) {
        return ClassPoolUtil.toCtClass(this.classPool, className);
    }

    protected CtClass[] toCtClassArray(String[] classNames) {
        return ClassPoolUtil.toCtClassArray(this.classPool, classNames);
    }

    protected CtClass[] toCtClassArray(Class<?>[] classes) {
        return ClassPoolUtil.toCtClassArray(this.classPool, classes);
    }

    protected CtClass createCtClass(String name) {
        return ClassPoolUtil.createCtClass(this.classPool, name);
    }

    protected CtClass createCtClass(String name, Class<?> superClass) {
        return ClassPoolUtil.createCtClass(this.classPool, name, superClass);
    }

    protected CtClass createCtClass(String name, CtClass superClass) {
        return ClassPoolUtil.createCtClass(this.classPool, name, superClass);
    }

    protected CtClass getAndRenameCtClass(Class<?> orgClass, String newName) {
        return this.getAndRenameCtClass(LdiClassUtil.getSimpleClassName(orgClass), newName);
    }

    protected CtClass getAndRenameCtClass(String orgName, String newName) {
        try {
            return this.classPool.getAndRename(orgName, newName);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
    }

    public Class<?> toClass(ClassLoader classLoader, CtClass ctClass) {
        try {
            byte[] bytecode = ctClass.toBytecode();
            return (Class)defineClassMethod.invoke((Object)classLoader, ctClass.getName(), bytecode, new Integer(0), new Integer(bytecode.length), protectionDomain);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(ClassLoader.class, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(ClassLoader.class, e);
        }
    }

    protected void setInterface(CtClass clazz, Class<?> interfaceType) {
        clazz.setInterfaces(new CtClass[]{this.toCtClass(interfaceType)});
    }

    protected void setInterfaces(CtClass clazz, Class<?>[] interfaces) {
        clazz.setInterfaces(this.toCtClassArray(interfaces));
    }

    protected CtConstructor createDefaultConstructor(Class<?> clazz) {
        return this.createDefaultConstructor(this.toCtClass(clazz));
    }

    protected CtConstructor createDefaultConstructor(CtClass clazz) {
        try {
            CtConstructor ctConstructor = CtNewConstructor.defaultConstructor((CtClass)clazz);
            clazz.addConstructor(ctConstructor);
            return ctConstructor;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected CtConstructor createConstructor(CtClass clazz, Constructor<?> constructor) {
        return this.createConstructor(clazz, this.toCtClassArray(constructor.getParameterTypes()), this.toCtClassArray(constructor.getExceptionTypes()));
    }

    protected CtConstructor createConstructor(CtClass clazz, CtClass[] parameterTypes, CtClass[] exceptionTypes) {
        try {
            CtConstructor ctConstructor = CtNewConstructor.make((CtClass[])parameterTypes, (CtClass[])exceptionTypes, (CtClass)clazz);
            clazz.addConstructor(ctConstructor);
            return ctConstructor;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected CtMethod getDeclaredMethod(CtClass clazz, String name, CtClass[] argTypes) {
        try {
            return clazz.getDeclaredMethod(name, argTypes);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
    }

    protected CtMethod createMethod(CtClass clazz, String src) {
        try {
            CtMethod ctMethod = CtNewMethod.make((String)src, (CtClass)clazz);
            clazz.addMethod(ctMethod);
            return ctMethod;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected CtMethod createMethod(CtClass clazz, Method method, String body) {
        return this.createMethod(clazz, method.getModifiers(), method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), body);
    }

    protected CtMethod createMethod(CtClass clazz, int modifier, Class<?> returnType, String methodName, Class<?>[] parameterTypes, Class<?>[] exceptionTypes, String body) {
        try {
            CtMethod ctMethod = CtNewMethod.make((int)(modifier & 0xFFFFFAFF), (CtClass)this.toCtClass(returnType), (String)methodName, (CtClass[])this.toCtClassArray(parameterTypes), (CtClass[])this.toCtClassArray(exceptionTypes), (String)body, (CtClass)clazz);
            clazz.addMethod(ctMethod);
            return ctMethod;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected void setMethodBody(CtMethod method, String src) {
        try {
            method.setBody(src);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Class[] paramTypes = new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class};
                try {
                    Class<?> loader = LdiClassUtil.forName(ClassLoader.class.getName());
                    defineClassMethod = loader.getDeclaredMethod(AbstractGenerator.DEFINE_CLASS_METHOD_NAME, paramTypes);
                    defineClassMethod.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchMethodRuntimeException(ClassLoader.class, AbstractGenerator.DEFINE_CLASS_METHOD_NAME, paramTypes, e);
                }
                return null;
            }
        });
    }
}

