/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.autoregister;

import java.util.ArrayList;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.autoregister.AbstractAutoRegister;
import org.lastaflute.di.core.autoregister.AutoNaming;
import org.lastaflute.di.core.autoregister.ClassPattern;
import org.lastaflute.di.core.autoregister.DefaultAutoNaming;
import org.lastaflute.di.core.customizer.ComponentCustomizer;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandler;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandlerFactory;
import org.lastaflute.di.core.meta.AutoBindingDef;
import org.lastaflute.di.core.meta.InstanceDef;
import org.lastaflute.di.util.ClassTraversal;
import org.lastaflute.di.util.LdiClassUtil;

public abstract class AbstractComponentAutoRegister
extends AbstractAutoRegister
implements ClassTraversal.ClassHandler {
    protected static final String CLASS_SUFFIX = ".class";
    public static final String autoNaming_BINDING = "bindingType=may";
    private AutoNaming autoNaming = new DefaultAutoNaming();
    public static final String instanceDef_BINDING = "bindingType=may";
    private InstanceDef instanceDef;
    public static final String autoBindingDef_BINDING = "bindingType=may";
    private AutoBindingDef autoBindingDef;
    private boolean externalBinding = false;
    public static final String customizer_BINDING = "bindingType=may";
    private ComponentCustomizer customizer;

    public AutoNaming getAutoNaming() {
        return this.autoNaming;
    }

    public void setAutoNaming(AutoNaming autoNaming) {
        this.autoNaming = autoNaming;
    }

    public InstanceDef getInstanceDef() {
        return this.instanceDef;
    }

    public void setInstanceDef(InstanceDef instanceDef) {
        this.instanceDef = instanceDef;
    }

    public AutoBindingDef getAutoBindingDef() {
        return this.autoBindingDef;
    }

    public void setAutoBindingDef(AutoBindingDef autoBindingDef) {
        this.autoBindingDef = autoBindingDef;
    }

    public boolean isExternalBinding() {
        return this.externalBinding;
    }

    public void setExternalBinding(boolean externalBinding) {
        this.externalBinding = externalBinding;
    }

    public ComponentCustomizer getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(ComponentCustomizer customizer) {
        this.customizer = customizer;
    }

    @Override
    public void processClass(String packageName, String shortClassName) {
        if (this.isIgnore(packageName, shortClassName)) {
            return;
        }
        for (int i = 0; i < this.getClassPatternSize(); ++i) {
            ClassPattern cp = this.getClassPattern(i);
            if (!cp.isAppliedPackageName(packageName) || !cp.isAppliedShortClassName(shortClassName)) continue;
            this.register(LdiClassUtil.concatName(packageName, shortClassName));
            return;
        }
    }

    protected void register(String className) {
        AnnotationHandler annoHandler = AnnotationHandlerFactory.getAnnotationHandler();
        ComponentDef cd = annoHandler.createComponentDef(className, this.instanceDef, this.autoBindingDef, this.externalBinding);
        if (cd.getComponentName() == null) {
            String[] names = LdiClassUtil.splitPackageAndShortClassName(className);
            cd.setComponentName(this.autoNaming.defineName(names[0], names[1]));
        }
        annoHandler.appendDI(cd);
        this.customize(cd);
        annoHandler.appendInitMethod(cd);
        annoHandler.appendDestroyMethod(cd);
        annoHandler.appendAspect(cd);
        annoHandler.appendInterType(cd);
        this.getContainer().register(cd);
    }

    protected void customize(ComponentDef componentDef) {
        if (this.customizer != null) {
            this.customizer.customize(componentDef);
        }
    }

    protected String[] getTargetPackages() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.getClassPatternSize(); ++i) {
            String packageName = this.getClassPattern(i).getPackageName();
            boolean append = true;
            for (int j = 0; j < result.size(); ++j) {
                String root = (String)result.get(j);
                if (packageName.equals(root)) {
                    append = false;
                    break;
                }
                if (packageName.startsWith(root)) {
                    append = false;
                    break;
                }
                if (!root.startsWith(packageName)) continue;
                result.set(j, packageName);
                append = false;
                break;
            }
            if (!append) continue;
            result.add(packageName);
        }
        return result.toArray(new String[result.size()]);
    }
}

