/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.lastaflute.di.exception.ClassNotFoundRuntimeException;
import org.lastaflute.di.exception.IORuntimeException;

public class LdiSerializeUtil {
    private static final int BYTE_ARRAY_SIZE = 8192;

    protected LdiSerializeUtil() {
    }

    public static Object serialize(Object o) throws IORuntimeException, ClassNotFoundRuntimeException {
        byte[] binary = LdiSerializeUtil.fromObjectToBinary(o);
        return LdiSerializeUtil.fromBinaryToObject(binary);
    }

    public static byte[] fromObjectToBinary(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(o);
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromBinaryToObject(byte[] binary) {
        Object object;
        ByteArrayInputStream bais = new ByteArrayInputStream(binary);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundRuntimeException(ex);
            }
        }
        ois.close();
        return object;
    }
}

