/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.dbcp.impl;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.lastaflute.jta.dbcp.ConnectionWrapper;
import org.lastaflute.jta.exception.LjtXAException;

public class XAResourceWrapperImpl
implements XAResource {
    protected final XAResource physicalXAResource;
    protected final ConnectionWrapper connectionWrapper;

    public XAResourceWrapperImpl(XAResource physicalXAResource, ConnectionWrapper connectionWrapper) {
        this.physicalXAResource = physicalXAResource;
        this.connectionWrapper = connectionWrapper;
    }

    public XAResource getPhysicalXAResource() {
        return this.physicalXAResource;
    }

    public ConnectionWrapper getConnectionWrapper() {
        return this.connectionWrapper;
    }

    protected void release() throws XAException {
        try {
            this.getConnectionWrapper().release();
        }
        catch (SQLException e) {
            throw new LjtXAException("Failed to release the connection: " + this.connectionWrapper, e);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        try {
            return this.getPhysicalXAResource().getTransactionTimeout();
        }
        catch (XAException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public boolean setTransactionTimeout(int arg0) throws XAException {
        try {
            return this.getPhysicalXAResource().setTransactionTimeout(arg0);
        }
        catch (XAException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public boolean isSameRM(XAResource arg0) throws XAException {
        try {
            return this.getPhysicalXAResource().isSameRM(arg0);
        }
        catch (XAException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public Xid[] recover(int arg0) throws XAException {
        try {
            return this.getPhysicalXAResource().recover(arg0);
        }
        catch (XAException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public int prepare(Xid arg0) throws XAException {
        try {
            return this.getPhysicalXAResource().prepare(arg0);
        }
        catch (XAException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void forget(Xid arg0) throws XAException {
        try {
            this.getPhysicalXAResource().forget(arg0);
        }
        catch (XAException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void rollback(Xid arg0) throws XAException {
        try {
            this.getPhysicalXAResource().rollback(arg0);
        }
        catch (XAException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void end(Xid arg0, int arg1) throws XAException {
        try {
            this.getPhysicalXAResource().end(arg0, arg1);
        }
        catch (XAException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void start(Xid arg0, int arg1) throws XAException {
        try {
            this.getPhysicalXAResource().start(arg0, arg1);
        }
        catch (XAException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void commit(Xid arg0, boolean arg1) throws XAException {
        try {
            this.getPhysicalXAResource().commit(arg0, arg1);
        }
        catch (XAException ex) {
            this.release();
            throw ex;
        }
    }
}

