/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.assembler;

import java.util.HashMap;
import java.util.Map;
import org.lastaflute.di.core.assembler.BindingTypeMayDef;
import org.lastaflute.di.core.assembler.BindingTypeMustDef;
import org.lastaflute.di.core.assembler.BindingTypeNoneDef;
import org.lastaflute.di.core.assembler.BindingTypeShouldDef;
import org.lastaflute.di.core.exception.IllegalBindingTypeDefRuntimeException;
import org.lastaflute.di.core.meta.BindingTypeDef;

public class BindingTypeDefFactory {
    public static final BindingTypeDef MUST = new BindingTypeMustDef("must");
    public static final BindingTypeDef SHOULD = new BindingTypeShouldDef("should");
    public static final BindingTypeDef MAY = new BindingTypeMayDef("may");
    public static final BindingTypeDef NONE = new BindingTypeNoneDef("none");
    private static final Map<String, BindingTypeDef> bindingTypeDefs = new HashMap<String, BindingTypeDef>();

    protected BindingTypeDefFactory() {
    }

    public static void addBindingTypeDef(BindingTypeDef bindingTypeDef) {
        bindingTypeDefs.put(bindingTypeDef.getName(), bindingTypeDef);
    }

    public static boolean existBindingTypeDef(String name) {
        return bindingTypeDefs.containsKey(name);
    }

    public static BindingTypeDef getBindingTypeDef(String name) {
        if (!BindingTypeDefFactory.existBindingTypeDef(name)) {
            throw new IllegalBindingTypeDefRuntimeException(name);
        }
        return bindingTypeDefs.get(name);
    }

    static {
        BindingTypeDefFactory.addBindingTypeDef(MUST);
        BindingTypeDefFactory.addBindingTypeDef(SHOULD);
        BindingTypeDefFactory.addBindingTypeDef(MAY);
        BindingTypeDefFactory.addBindingTypeDef(NONE);
    }
}

