/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.beans.exception;

import org.lastaflute.di.exception.SRuntimeException;
import org.lastaflute.di.util.LdiMethodUtil;

public class BeanMethodNotFoundException
extends SRuntimeException {
    private static final long serialVersionUID = -3508955801981550317L;
    private Class<?> targetClass;
    private String methodName;
    private Class<?>[] methodArgClasses;

    public BeanMethodNotFoundException(Class<?> targetClass, String methodName, Object[] methodArgs) {
        super("ESSR0049", new Object[]{targetClass.getName(), LdiMethodUtil.getSignature(methodName, methodArgs)});
        this.targetClass = targetClass;
        this.methodName = methodName;
        if (methodArgs != null) {
            this.methodArgClasses = new Class[methodArgs.length];
            for (int i = 0; i < methodArgs.length; ++i) {
                if (methodArgs[i] == null) continue;
                this.methodArgClasses[i] = methodArgs[i].getClass();
            }
        }
    }

    public BeanMethodNotFoundException(Class<?> targetClass, String methodName, Class<?>[] methodArgClasses) {
        super("ESSR0049", new Object[]{targetClass.getName(), LdiMethodUtil.getSignature(methodName, methodArgClasses)});
        this.targetClass = targetClass;
        this.methodName = methodName;
        this.methodArgClasses = methodArgClasses;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getMethodArgClasses() {
        return this.methodArgClasses;
    }
}

