/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Locator;

public class TagHandlerContext {
    private static final Integer ONE = new Integer(1);
    private StringBuffer body = null;
    private StringBuffer characters = new StringBuffer();
    private Stack<StringBuffer> bodyStack = new Stack();
    private StringBuffer path = new StringBuffer();
    private StringBuffer detailPath = new StringBuffer();
    private String qName = "";
    private Stack<String> qNameStack = new Stack();
    private Object result;
    private Stack<Object> stack = new Stack();
    private Map<String, Integer> pathCounts = new HashMap<String, Integer>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Locator locator = new Locator(){

        @Override
        public int getColumnNumber() {
            return 0;
        }

        @Override
        public int getLineNumber() {
            return 0;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }
    };

    public void push(Object o) {
        if (this.stack.empty()) {
            this.result = o;
        }
        this.stack.push(o);
    }

    public Object getResult() {
        return this.result;
    }

    public Object pop() {
        return this.stack.pop();
    }

    public Object peek() {
        return this.stack.peek();
    }

    public Object peek(int n) {
        return this.stack.get(this.stack.size() - n - 1);
    }

    public Object peek(Class<?> clazz) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Object o = this.stack.get(i);
            if (!clazz.isInstance(o)) continue;
            return o;
        }
        return null;
    }

    public Object peekFirst() {
        return this.stack.get(0);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public void addParameter(String name, Object parameter) {
        this.parameters.put(name, parameter);
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String qName) {
        this.bodyStack.push(this.body);
        this.body = new StringBuffer();
        this.characters = new StringBuffer();
        this.qNameStack.push(this.qName);
        this.qName = qName;
        this.path.append("/");
        this.path.append(qName);
        int pathCount = this.incrementPathCount();
        this.detailPath.append("/");
        this.detailPath.append(qName);
        this.detailPath.append("[");
        this.detailPath.append(pathCount);
        this.detailPath.append("]");
    }

    public void characters(char[] buffer, int start, int length) {
        this.body.append(buffer, start, length);
        this.characters.append(buffer, start, length);
    }

    public String getCharacters() {
        return this.characters.toString().trim();
    }

    public String getBody() {
        return this.body.toString().trim();
    }

    public boolean isCharactersEol() {
        if (this.characters.length() == 0) {
            return false;
        }
        return this.characters.charAt(this.characters.length() - 1) == '\n';
    }

    public void clearCharacters() {
        this.characters = new StringBuffer();
    }

    public void endElement() {
        this.body = this.bodyStack.pop();
        TagHandlerContext.remoteLastPath(this.path);
        TagHandlerContext.remoteLastPath(this.detailPath);
        this.qName = this.qNameStack.pop();
    }

    private static void remoteLastPath(StringBuffer path) {
        path.delete(path.lastIndexOf("/"), path.length());
    }

    public String getPath() {
        return this.path.toString();
    }

    public String getDetailPath() {
        return this.detailPath.toString();
    }

    public String getQName() {
        return this.qName;
    }

    private int incrementPathCount() {
        String path = this.getPath();
        Integer pathCount = this.pathCounts.get(path);
        pathCount = pathCount == null ? ONE : new Integer(pathCount + 1);
        this.pathCounts.put(path, pathCount);
        return pathCount;
    }
}

