/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.redefiner.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.assembler.AbstractPropertyAssembler;
import org.lastaflute.di.core.assembler.BindingTypeDefFactory;
import org.lastaflute.di.core.meta.AccessTypeDef;
import org.lastaflute.di.core.meta.PropertyDef;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.PropertyDesc;
import org.lastaflute.di.helper.beans.exception.BeanIllegalPropertyException;
import org.lastaflute.di.redefiner.LaContainerPreparer;
import org.lastaflute.di.redefiner.annotation.ManualBindingProperties;
import org.lastaflute.di.redefiner.util.ClassBuilderUtils;

public class ClassAutoPropertyAssembler
extends AbstractPropertyAssembler {
    public ClassAutoPropertyAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    @Override
    public void assemble(Object component) throws BeanIllegalPropertyException {
        if (component == null) {
            return;
        }
        BeanDesc beanDesc = this.getBeanDesc(component);
        ComponentDef cd = this.getComponentDef();
        int defSize = cd.getPropertyDefSize();
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < defSize; ++i) {
            PropertyDef propDef = cd.getPropertyDef(i);
            AccessTypeDef accessTypeDef = propDef.getAccessTypeDef();
            accessTypeDef.bind(cd, propDef, component);
            String propName = propDef.getPropertyName();
            names.add(propName);
        }
        LaContainerPreparer preparer = ClassBuilderUtils.getPreparer(this.getComponentDef());
        if (preparer != null) {
            names.addAll(Arrays.asList(this.getManualBindingProperties(preparer, this.getComponentDef().getComponentName())));
        }
        if (cd.isExternalBinding()) {
            this.bindExternally(beanDesc, cd, component, names);
        }
        int descSize = beanDesc.getPropertyDescSize();
        for (int i = 0; i < descSize; ++i) {
            PropertyDesc propDesc = beanDesc.getPropertyDesc(i);
            String propName = propDesc.getPropertyName();
            if (names.contains(propName)) continue;
            BindingTypeDefFactory.SHOULD.bind(this.getComponentDef(), null, propDesc, component);
        }
    }

    protected String[] getManualBindingProperties(LaContainerPreparer preparer, String componentName) {
        ManualBindingProperties annotation;
        Method method = ClassBuilderUtils.findMethod(preparer.getClass(), componentName, "define");
        if (method != null && (annotation = method.getAnnotation(ManualBindingProperties.class)) != null) {
            return annotation.value();
        }
        return new String[0];
    }
}

