/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.redefiner.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.factory.LaContainerFactory;
import org.lastaflute.di.core.factory.dixml.DiXmlLaContainerBuilder;
import org.lastaflute.di.helper.xml.SaxHandlerParser;
import org.lastaflute.di.helper.xml.TagHandlerContext;
import org.lastaflute.di.redefiner.core.RedefinableComponentTagHandler;
import org.lastaflute.di.redefiner.core.RedefinableComponentsTagHandler;
import org.lastaflute.di.redefiner.util.LaContainerBuilderUtils;

public class RedefinableXmlLaContainerBuilder
extends DiXmlLaContainerBuilder {
    public static final String DELIMITER = "+";
    protected static final String NAME_ADDITIONAL = "+";
    protected static final String PARAMETER_BUILDER = "builder";
    protected static final String PARAMETER_BASEPATH = "originalPath";
    protected static final ThreadLocal<LinkedList<String>> basePathStack_ = new ThreadLocal();

    public RedefinableXmlLaContainerBuilder() {
        this.rule.addTagHandler("/components", new RedefinableComponentsTagHandler());
        this.rule.addTagHandler("component", new RedefinableComponentTagHandler());
    }

    @Override
    protected SaxHandlerParser createSaxHandlerParser(LaContainer parent, String path) {
        SaxHandlerParser parser = super.createSaxHandlerParser(parent, path);
        TagHandlerContext context = parser.getSaxHandler().getTagHandlerContext();
        context.addParameter(PARAMETER_BUILDER, this);
        context.addParameter(PARAMETER_BASEPATH, this.getCurrentBasePath());
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LaContainer parse(LaContainer parent, String path) {
        this.pushPath(path);
        try {
            LaContainer container = super.parse(parent, path);
            this.mergeContainers(container, path, true);
            LaContainer laContainer = container;
            return laContainer;
        }
        finally {
            this.popPath(path);
        }
    }

    protected void popPath(String path) {
        if (path.equals(this.getCurrentBasePath())) {
            LinkedList<String> pathStack = basePathStack_.get();
            pathStack.removeFirst();
            if (pathStack.isEmpty()) {
                basePathStack_.set(null);
            }
        }
    }

    protected String getCurrentBasePath() {
        LinkedList<String> pathStack = basePathStack_.get();
        if (pathStack == null || pathStack.isEmpty()) {
            return null;
        }
        return pathStack.peek();
    }

    protected void pushPath(String path) {
        LinkedList<String> pathStack = basePathStack_.get();
        if (pathStack == null) {
            pathStack = new LinkedList();
            basePathStack_.set(pathStack);
        }
        if (this.isBasePath(path)) {
            pathStack.addFirst(path);
        }
    }

    protected boolean isBasePath(String path) {
        if (path == null) {
            return true;
        }
        return path.indexOf("++") < 0 && path.indexOf("++") < 0;
    }

    protected void mergeContainers(LaContainer container, String path, boolean addToTail) {
        Set<URL> additionalURLSet = this.gatherAdditionalDiconURLs(path, addToTail);
        Iterator<URL> itr = additionalURLSet.iterator();
        while (itr.hasNext()) {
            String url = itr.next().toExternalForm();
            if (!LaContainerBuilderUtils.resourceExists(url, this)) continue;
            LaContainerBuilderUtils.mergeContainer(container, LaContainerFactory.create(url));
        }
    }

    protected Set<URL> gatherAdditionalDiconURLs(String path, boolean addToTail) {
        String[] additionalDiconPaths = this.constructAdditionalDiconPaths(path, addToTail);
        LinkedHashSet<URL> urlSet = new LinkedHashSet<URL>();
        for (int i = 0; i < additionalDiconPaths.length; ++i) {
            URL[] urls = LaContainerBuilderUtils.getResourceURLs(additionalDiconPaths[i]);
            for (int j = 0; j < urls.length; ++j) {
                urlSet.add(urls[j]);
            }
        }
        return urlSet;
    }

    protected String[] constructAdditionalDiconPaths(String path, boolean addToTail) {
        String suffix;
        String name;
        String dir;
        int delimiter = path.lastIndexOf("+");
        int slash = path.lastIndexOf(47);
        if (delimiter >= 0 && delimiter > slash) {
            return new String[0];
        }
        ArrayList<String> pathList = new ArrayList<String>();
        if (slash < 0) {
            dir = "";
            name = path;
        } else {
            dir = path.substring(0, slash + 1);
            name = path.substring(slash + 1);
        }
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            suffix = "";
        } else {
            suffix = name.substring(dot);
            name = name.substring(0, dot);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(dir);
        if (!addToTail) {
            sb.append("+").append("+");
        }
        sb.append(name);
        if (addToTail) {
            sb.append("+").append("+");
        }
        sb.append(suffix);
        String additionalPath = sb.toString();
        String additionalResourcePath = LaContainerBuilderUtils.fromURLToResourcePath(additionalPath);
        if (additionalResourcePath != null) {
            pathList.add(additionalResourcePath);
        }
        pathList.add(additionalPath);
        return pathList.toArray(new String[0]);
    }
}

