/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.lastaflute.di.util.LdiDecimalFormatUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class LdiLongConversionUtil {
    protected LdiLongConversionUtil() {
    }

    public static Long toLong(Object o) {
        return LdiLongConversionUtil.toLong(o, null);
    }

    public static Long toLong(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return new Long(((Number)o).longValue());
        }
        if (o instanceof String) {
            return LdiLongConversionUtil.toLong((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Long(new SimpleDateFormat(pattern).format(o));
            }
            return new Long(((Date)o).getTime());
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? new Long(1L) : new Long(0L);
        }
        return LdiLongConversionUtil.toLong(o.toString());
    }

    private static Long toLong(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return null;
        }
        return new Long(LdiDecimalFormatUtil.normalize(s));
    }

    public static long toPrimitiveLong(Object o) {
        return LdiLongConversionUtil.toPrimitiveLong(o, null);
    }

    public static long toPrimitiveLong(Object o, String pattern) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return LdiLongConversionUtil.toPrimitiveLong((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Long.parseLong(new SimpleDateFormat(pattern).format(o));
            }
            return ((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        return LdiLongConversionUtil.toPrimitiveLong(o.toString());
    }

    private static long toPrimitiveLong(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return 0L;
        }
        return Long.parseLong(LdiDecimalFormatUtil.normalize(s));
    }
}

