/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.dbcp;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.lastaflute.jta.dbcp.impl.XAConnectionImpl;
import org.lastaflute.jta.util.LjtDriverManagerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleXADataSource
implements XADataSource {
    private static final Logger logger = LoggerFactory.getLogger(SimpleXADataSource.class);
    protected String driverClassName;
    protected String url;
    protected String user;
    protected String password;
    protected final Properties properties = new Properties();
    protected int loginTimeout;

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        if (driverClassName != null && driverClassName.length() > 0) {
            LjtDriverManagerUtil.registerDriver(driverClassName);
        }
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.user, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        Properties info = new Properties();
        info.putAll((Map<?, ?>)this.properties);
        if (!this.isEmpty(user)) {
            info.put("user", user);
        }
        if (!this.isEmpty(password)) {
            info.put("password", password);
        }
        int currentLoginTimeout = DriverManager.getLoginTimeout();
        try {
            DriverManager.setLoginTimeout(this.loginTimeout);
            Connection con = DriverManager.getConnection(this.url, info);
            XAConnectionImpl xAConnectionImpl = new XAConnectionImpl(con);
            return xAConnectionImpl;
        }
        finally {
            try {
                DriverManager.setLoginTimeout(currentLoginTimeout);
            }
            catch (Exception e) {
                logger.info("Failed to set login timeout: currentLoginTimeout=" + currentLoginTimeout, (Throwable)e);
            }
        }
    }

    protected boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

