/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.exception;

import org.lastaflute.di.helper.message.MessageFormatter;

public class SRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -4452607868694297329L;
    private String messageCode;
    private Object[] args;
    private String message;
    private String simpleMessage;

    public SRuntimeException(String messageCode) {
        this(messageCode, null, null);
    }

    public SRuntimeException(String messageCode, Object[] args) {
        this(messageCode, args, null);
    }

    public SRuntimeException(String messageCode, Object[] args, Throwable cause) {
        super(cause);
        this.messageCode = messageCode;
        this.args = args;
        this.simpleMessage = MessageFormatter.getSimpleMessage(messageCode, args);
        this.message = "[" + messageCode + "]" + this.simpleMessage;
    }

    public final String getMessageCode() {
        return this.messageCode;
    }

    public final Object[] getArgs() {
        return this.args;
    }

    @Override
    public final String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    public final String getSimpleMessage() {
        return this.simpleMessage;
    }
}

