/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.assembler;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LastaDiProperties;
import org.lastaflute.di.core.assembler.AbstractPropertyAssembler;
import org.lastaflute.di.core.assembler.BindingTypeDefFactory;
import org.lastaflute.di.core.meta.BindingTypeDef;
import org.lastaflute.di.core.meta.PropertyDef;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.PropertyDesc;

public class AutoPropertyAssembler
extends AbstractPropertyAssembler {
    public AutoPropertyAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    @Override
    public void assemble(Object component) {
        if (component == null) {
            return;
        }
        BeanDesc beanDesc = this.getBeanDesc(component);
        ComponentDef componentDef = this.getComponentDef();
        int defSize = componentDef.getPropertyDefSize();
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < defSize; ++i) {
            PropertyDef propDef = componentDef.getPropertyDef(i);
            propDef.getAccessTypeDef().bind(componentDef, propDef, component);
            names.add(propDef.getPropertyName());
        }
        if (componentDef.isExternalBinding()) {
            this.bindExternally(beanDesc, componentDef, component, names);
        }
        this.setupPlainProperty(component, beanDesc, componentDef, names);
    }

    protected void setupPlainProperty(Object component, BeanDesc beanDesc, ComponentDef componentDef, Set<String> names) {
        BindingTypeDef bindingTypeDef = BindingTypeDefFactory.getBindingTypeDef("should");
        int descSize = beanDesc.getPropertyDescSize();
        for (int i = 0; i < descSize; ++i) {
            PropertyDesc propDesc = beanDesc.getPropertyDesc(i);
            if (!this.needsPlainPropertyInjection(propDesc) || names.contains(propDesc.getPropertyName())) continue;
            bindingTypeDef.bind(componentDef, null, propDesc, component);
        }
    }

    protected boolean needsPlainPropertyInjection(PropertyDesc propDesc) {
        Method writeMethod = propDesc.getWriteMethod();
        if (writeMethod == null) {
            return false;
        }
        String fqcn = writeMethod.getDeclaringClass().getName();
        if (fqcn.startsWith("org.lastaflute.") || fqcn.startsWith("org.dbflute.")) {
            return true;
        }
        String specified1 = LastaDiProperties.getInstance().getPlainPropertyInjectionPackage1();
        return specified1 != null && fqcn.startsWith(specified1);
    }
}

