/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.autoregister;

import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.autoregister.AbstractAutoRegister;
import org.lastaflute.di.core.autoregister.ClassPattern;
import org.lastaflute.di.util.LdiClassUtil;

public abstract class AbstractComponentTargetAutoRegister
extends AbstractAutoRegister {
    @Override
    public void registerAll() {
        LaContainer container = this.getContainer();
        for (int i = 0; i < container.getComponentDefSize(); ++i) {
            ComponentDef cd = container.getComponentDef(i);
            if (!this.isAppliedComponent(cd)) continue;
            this.register(cd);
        }
    }

    protected abstract void register(ComponentDef var1);

    protected boolean isAppliedComponent(ComponentDef cd) {
        Class<?> componentClass = cd.getComponentClass();
        if (componentClass == null) {
            return false;
        }
        String packageName = LdiClassUtil.getPackageName(componentClass);
        String shortClassName = LdiClassUtil.getShortClassName(componentClass);
        for (int i = 0; i < this.getClassPatternSize(); ++i) {
            ClassPattern cp = this.getClassPattern(i);
            if (this.isIgnore(packageName, shortClassName)) {
                return false;
            }
            if (!cp.isAppliedPackageName(packageName) || !cp.isAppliedShortClassName(shortClassName)) continue;
            return true;
        }
        return false;
    }
}

