/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.autoregister;

import java.util.regex.Pattern;
import org.lastaflute.di.util.LdiStringUtil;

public class ClassPattern {
    private String packageName;
    private Pattern[] shortClassNamePatterns;

    public ClassPattern() {
    }

    public ClassPattern(String packageName, String shortClassNames) {
        this.setPackageName(packageName);
        this.setShortClassNames(shortClassNames);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setShortClassNames(String shortClassNames) {
        String[] classNames = LdiStringUtil.split(shortClassNames, ",");
        this.shortClassNamePatterns = new Pattern[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            String s = classNames[i].trim();
            this.shortClassNamePatterns[i] = Pattern.compile(s);
        }
    }

    public boolean isAppliedShortClassName(String shortClassName) {
        if (this.shortClassNamePatterns == null) {
            return true;
        }
        for (int i = 0; i < this.shortClassNamePatterns.length; ++i) {
            if (!this.shortClassNamePatterns[i].matcher(shortClassName).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isAppliedPackageName(String pName) {
        if (!LdiStringUtil.isEmpty(pName) && !LdiStringUtil.isEmpty(this.packageName)) {
            return ClassPattern.appendDelimiter(pName).startsWith(ClassPattern.appendDelimiter(this.packageName));
        }
        return LdiStringUtil.isEmpty(pName) && LdiStringUtil.isEmpty(this.packageName);
    }

    protected static String appendDelimiter(String name) {
        return name.endsWith(".") ? name : name + ".";
    }
}

