/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.customizer;

import java.lang.reflect.Method;
import java.util.Map;
import javax.transaction.Transactional;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.customizer.AbstractCustomizer;
import org.lastaflute.di.core.factory.AspectDefFactory;
import org.lastaflute.di.util.LdiStringUtil;
import org.lastaflute.di.util.tiger.LdiCollectionsUtil;

public abstract class PointTxAttributeCustomizer
extends AbstractCustomizer {
    protected static final Map<Transactional.TxType, String> txInterceptors = LdiCollectionsUtil.newHashMap();

    @Override
    protected void doCustomize(ComponentDef componentDef) {
        Class<?> componentClass = componentDef.getComponentClass();
        if (componentClass.getAnnotation(Transactional.class) != null) {
            String msg = "Cannot use the transactional annotation for class, use for method: " + componentDef;
            throw new IllegalStateException(msg);
        }
        for (Method method : componentClass.getMethods()) {
            Transactional.TxType methodAttrType;
            String interceptorName;
            Transactional methodAttr;
            if (method.isSynthetic() || method.isBridge() || method.getDeclaringClass() == Object.class || this.isOutOfTxMethod(methodAttr = method.getAnnotation(Transactional.class), method) || LdiStringUtil.isEmpty(interceptorName = txInterceptors.get(methodAttrType = methodAttr.value()))) continue;
            componentDef.addAspectDef(AspectDefFactory.createAspectDef(interceptorName, method));
        }
    }

    protected boolean isOutOfTxMethod(Transactional methodAttr, Method method) {
        return methodAttr == null || this.isImplicitTxSupportedMethod(method);
    }

    protected abstract boolean isImplicitTxSupportedMethod(Method var1);

    static {
        txInterceptors.put(Transactional.TxType.MANDATORY, "tx_aop.mandatoryTx");
        txInterceptors.put(Transactional.TxType.REQUIRED, "tx_aop.requiredTx");
        txInterceptors.put(Transactional.TxType.REQUIRES_NEW, "tx_aop.requiresNewTx");
        txInterceptors.put(Transactional.TxType.NOT_SUPPORTED, "tx_aop.notSupportedTx");
        txInterceptors.put(Transactional.TxType.NEVER, "tx_aop.neverTx");
    }
}

