/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.defbuilder.impl;

import java.lang.reflect.Method;
import javax.annotation.PreDestroy;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.exception.IllegalDestroyMethodAnnotationRuntimeException;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandler;
import org.lastaflute.di.core.factory.defbuilder.DestroyMethodDefBuilder;
import org.lastaflute.di.core.meta.impl.DestroyMethodDefImpl;

public class DestroyMethodDefBuilderImpl
implements DestroyMethodDefBuilder {
    @Override
    public void appendDestroyMethodDef(AnnotationHandler annotationHandler, ComponentDef componentDef) {
        Class<?> componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        for (Method method : componentClass.getMethods()) {
            PreDestroy destroyMethod;
            if (method.isBridge() || method.isSynthetic() || (destroyMethod = method.getAnnotation(PreDestroy.class)) == null) continue;
            if (method.getParameterTypes().length != 0) {
                throw new IllegalDestroyMethodAnnotationRuntimeException(componentClass, method.getName());
            }
            if (!annotationHandler.isDestroyMethodRegisterable(componentDef, method.getName())) continue;
            componentDef.addDestroyMethodDef(this.newDestroyMethodDefImpl(method));
        }
    }

    protected DestroyMethodDefImpl newDestroyMethodDefImpl(Method method) {
        return new DestroyMethodDefImpl(method);
    }
}

