/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.message;

import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.lastaflute.di.Disposable;
import org.lastaflute.di.DisposableUtil;
import org.lastaflute.di.exception.ResourceNotFoundException;
import org.lastaflute.di.exception.ResourceNotFoundRuntimeException;
import org.lastaflute.di.helper.message.MessageResourceBundle;
import org.lastaflute.di.helper.message.MessageResourceBundleFacade;
import org.lastaflute.di.util.LdiAssertionUtil;
import org.lastaflute.di.util.LdiResourceUtil;

public class MessageResourceBundleFactory {
    private static final String PROPERTIES_EXT = ".properties";
    private static final Object NOT_FOUND = new Object();
    private static final Map<String, Object> cacheMap = new HashMap<String, Object>();
    private static boolean initialized = false;

    public static MessageResourceBundle getBundle(String baseName) {
        return MessageResourceBundleFactory.getBundle(baseName, Locale.getDefault());
    }

    public static MessageResourceBundle getBundle(String baseName, Locale locale) throws ResourceNotFoundRuntimeException {
        MessageResourceBundle bundle = MessageResourceBundleFactory.getNullableBundle(baseName, locale);
        if (bundle != null) {
            return bundle;
        }
        throw new ResourceNotFoundException("Not found the resource bundle: " + baseName + " " + locale);
    }

    protected static MessageResourceBundle getNullableBundle(String baseName) {
        return MessageResourceBundleFactory.getNullableBundle(baseName, Locale.getDefault());
    }

    protected static MessageResourceBundle getNullableBundle(String baseName, Locale locale) {
        LdiAssertionUtil.assertNotNull("baseName", baseName);
        LdiAssertionUtil.assertNotNull("locale", locale);
        String base = baseName.replace('.', '/');
        String[] bundleNames = MessageResourceBundleFactory.calculateBundleNames(base, locale);
        MessageResourceBundleFacade parentFacade = null;
        MessageResourceBundleFacade facade = null;
        int length = bundleNames.length;
        for (int i = 0; i < length; ++i) {
            facade = MessageResourceBundleFactory.loadFacade(bundleNames[i] + PROPERTIES_EXT);
            if (parentFacade == null) {
                parentFacade = facade;
                continue;
            }
            if (facade == null) continue;
            facade.setParent(parentFacade);
            parentFacade = facade;
        }
        if (parentFacade != null) {
            return parentFacade.getBundle();
        }
        return null;
    }

    protected static String[] calculateBundleNames(String baseName, Locale locale) {
        boolean hasVariant;
        boolean hasCountry;
        boolean hasLanguage;
        int length = 1;
        boolean bl = hasLanguage = locale.getLanguage().length() > 0;
        if (hasLanguage) {
            ++length;
        }
        boolean bl2 = hasCountry = locale.getCountry().length() > 0;
        if (hasCountry) {
            ++length;
        }
        boolean bl3 = hasVariant = locale.getVariant().length() > 0;
        if (hasVariant) {
            ++length;
        }
        String[] result = new String[length];
        int index = 0;
        result[index++] = baseName;
        if (!(hasLanguage || hasCountry || hasVariant)) {
            return result;
        }
        StringBuffer buffer = new StringBuffer(baseName);
        buffer.append('_');
        buffer.append(locale.getLanguage());
        if (hasLanguage) {
            result[index++] = new String(buffer);
        }
        if (!hasCountry && !hasVariant) {
            return result;
        }
        buffer.append('_');
        buffer.append(locale.getCountry());
        if (hasCountry) {
            result[index++] = new String(buffer);
        }
        if (!hasVariant) {
            return result;
        }
        buffer.append('_');
        buffer.append(locale.getVariant());
        result[index++] = new String(buffer);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MessageResourceBundleFacade loadFacade(String path) {
        Map<String, Object> map = cacheMap;
        synchronized (map) {
            Object cachedFacade;
            if (!initialized) {
                DisposableUtil.add(new Disposable(){

                    @Override
                    public void dispose() {
                        MessageResourceBundleFactory.clear();
                        initialized = false;
                    }
                });
                initialized = true;
            }
            if ((cachedFacade = cacheMap.get(path)) == NOT_FOUND) {
                return null;
            }
            if (cachedFacade != null) {
                return (MessageResourceBundleFacade)cachedFacade;
            }
            URL url = LdiResourceUtil.getResourceNoException(path);
            if (url != null) {
                MessageResourceBundleFacade facade = new MessageResourceBundleFacade(url);
                cacheMap.put(path, facade);
                return facade;
            }
            cacheMap.put(path, NOT_FOUND);
        }
        return null;
    }

    public static void clear() {
        cacheMap.clear();
    }
}

