/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.redefiner.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.lastaflute.di.core.factory.resresolver.impl.ClassPathResourceResolver;
import org.lastaflute.di.exception.IORuntimeException;
import org.lastaflute.di.redefiner.util.LaContainerBuilderUtils;
import org.lastaflute.di.util.LdiResourceUtil;

public class RedefinableResourceResolver
extends ClassPathResourceResolver {
    private static final char COLON = ':';

    @Override
    public InputStream getInputStream(String path) {
        String[] paths = this.constructRedefinedDiconPaths(path);
        for (int i = 0; i < paths.length; ++i) {
            try {
                InputStream is = super.getInputStream(paths[i]);
                if (is == null) continue;
                return is;
            }
            catch (IORuntimeException iORuntimeException) {
                // empty catch block
            }
        }
        return super.getInputStream(path);
    }

    @Override
    protected URL getURL(String path) {
        return this.toURL_corrected(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    URL toURL_corrected(String path) {
        if (path.indexOf(58) < 0) return LdiResourceUtil.getResourceNoException(path);
        try {
            URL url = new URL(path);
            InputStream is = null;
            try {
                is = url.openStream();
                URL uRL = url;
                return uRL;
            }
            catch (IOException ex) {
                URL uRL2 = null;
                return uRL2;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return LdiResourceUtil.getResourceNoException(path);
    }

    protected String[] constructRedefinedDiconPaths(String path) {
        String suffix;
        String body;
        int delimiter = path.lastIndexOf("+");
        int slash = path.lastIndexOf(47);
        if (delimiter >= 0 && delimiter > slash) {
            return new String[0];
        }
        ArrayList<String> pathList = new ArrayList<String>();
        int dot = path.lastIndexOf(46);
        if (dot < 0) {
            body = path;
            suffix = "";
        } else {
            body = path.substring(0, dot);
            suffix = path.substring(dot);
        }
        String resourceBody = LaContainerBuilderUtils.fromURLToResourcePath(body + "+" + suffix);
        if (resourceBody != null) {
            pathList.add(resourceBody);
        }
        pathList.add(body + "+" + suffix);
        return pathList.toArray(new String[0]);
    }
}

