/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

public class LdiBooleanConversionUtil {
    protected LdiBooleanConversionUtil() {
    }

    public static Boolean toBoolean(Object obj) {
        if (obj == null) {
            return (Boolean)obj;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            int num = ((Number)obj).intValue();
            if (num == 1) {
                return Boolean.TRUE;
            }
            if (num == 0) {
                return Boolean.FALSE;
            }
            String msg = "Failed to parse the boolean number: number=" + num;
            throw new IllegalStateException(msg);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if ("true".equalsIgnoreCase(str)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
            if (str.equalsIgnoreCase("1")) {
                return Boolean.TRUE;
            }
            if (str.equalsIgnoreCase("0")) {
                return Boolean.FALSE;
            }
            if (str.equalsIgnoreCase("t")) {
                return Boolean.TRUE;
            }
            if (str.equalsIgnoreCase("f")) {
                return Boolean.FALSE;
            }
            String msg = "Failed to parse the boolean string:";
            msg = msg + " value=" + str;
            throw new IllegalStateException(msg);
        }
        return Boolean.FALSE;
    }

    public static boolean toPrimitiveBoolean(Object o) {
        Boolean b = LdiBooleanConversionUtil.toBoolean(o);
        if (b != null) {
            return b;
        }
        return false;
    }
}

