/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class LdiModifierUtil {
    static final int BRIDGE = 64;
    static final int SYNTHETIC = 4096;

    protected LdiModifierUtil() {
    }

    public static boolean isPublic(Method m) {
        return LdiModifierUtil.isPublic(m.getModifiers());
    }

    public static boolean isPublic(Field f) {
        return LdiModifierUtil.isPublic(f.getModifiers());
    }

    public static boolean isPublicStaticFinalField(Field f) {
        return LdiModifierUtil.isPublicStaticFinal(f.getModifiers());
    }

    public static boolean isPublicStaticFinal(int modifier) {
        return LdiModifierUtil.isPublic(modifier) && LdiModifierUtil.isStatic(modifier) && LdiModifierUtil.isFinal(modifier);
    }

    public static boolean isPublic(int modifier) {
        return Modifier.isPublic(modifier);
    }

    public static boolean isAbstract(Class<?> clazz) {
        return LdiModifierUtil.isAbstract(clazz.getModifiers());
    }

    public static boolean isAbstract(int modifier) {
        return Modifier.isAbstract(modifier);
    }

    public static boolean isStatic(int modifier) {
        return Modifier.isStatic(modifier);
    }

    public static boolean isFinal(int modifier) {
        return Modifier.isFinal(modifier);
    }

    public static boolean isFinal(Method method) {
        return LdiModifierUtil.isFinal(method.getModifiers());
    }

    public static boolean isFinal(Field field) {
        return LdiModifierUtil.isFinal(field.getModifiers());
    }

    public static boolean isTransient(Field field) {
        return LdiModifierUtil.isTransient(field.getModifiers());
    }

    public static boolean isTransient(int modifier) {
        return Modifier.isTransient(modifier);
    }

    public static boolean isInstanceField(Field field) {
        int m = field.getModifiers();
        return !LdiModifierUtil.isStatic(m) && !LdiModifierUtil.isFinal(m);
    }
}

