/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.dbcp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.lastaflute.di.core.LastaDiProperties;
import org.lastaflute.jta.dbcp.ConnectionPool;
import org.lastaflute.jta.dbcp.ConnectionWrapper;
import org.lastaflute.jta.dbcp.exception.ConnectionPoolShortFreeSQLException;
import org.lastaflute.jta.dbcp.impl.ConnectionWrapperImpl;
import org.lastaflute.jta.exception.LjtIllegalStateException;
import org.lastaflute.jta.exception.LjtRuntimeException;
import org.lastaflute.jta.exception.LjtSQLException;
import org.lastaflute.jta.helper.LjtLinkedList;
import org.lastaflute.jta.helper.misc.LjtExceptionMessageBuilder;
import org.lastaflute.jta.helper.timer.LjtTimeoutManager;
import org.lastaflute.jta.helper.timer.LjtTimeoutTarget;
import org.lastaflute.jta.helper.timer.LjtTimeoutTask;
import org.lastaflute.jta.util.LjtTransactionManagerUtil;
import org.lastaflute.jta.util.LjtTransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleConnectionPool
implements ConnectionPool {
    private static final Logger logger = LoggerFactory.getLogger(SimpleConnectionPool.class);
    protected static final int DEFAULT_TRANSACTION_ISOLATION_LEVEL = -1;
    protected XADataSource xaDataSource;
    protected TransactionManager transactionManager;
    protected int maxPoolSize = 10;
    protected int minPoolSize = 0;
    protected long maxWait = 10000L;
    protected int timeout = 600;
    protected boolean suppressLocalTx;
    protected boolean readOnly;
    protected int transactionIsolationLevel = -1;
    protected String validationQuery;
    protected long validationInterval;
    protected final Set<ConnectionWrapper> activePool = this.createActivePoolSet();
    protected final Map<Transaction, ConnectionWrapper> txActivePool = this.createTxActivePoolMap();
    protected final LjtLinkedList freePool = this.createFreePoolList();
    protected final LjtTimeoutTask timeoutTask = LjtTimeoutManager.getInstance().addTimeoutTarget(this.createTimeoutTarget(), Integer.MAX_VALUE, true);

    protected Set<ConnectionWrapper> createActivePoolSet() {
        return new HashSet<ConnectionWrapper>();
    }

    protected Map<Transaction, ConnectionWrapper> createTxActivePoolMap() {
        return new HashMap<Transaction, ConnectionWrapper>();
    }

    protected LjtLinkedList createFreePoolList() {
        return new LjtLinkedList();
    }

    protected LjtTimeoutTarget createTimeoutTarget() {
        return new LjtTimeoutTarget(){

            @Override
            public void expired() {
            }
        };
    }

    @Override
    public synchronized ConnectionWrapper checkOut() throws SQLException {
        Transaction tx = this.getTransaction();
        if (tx == null && this.isSuppressLocalTx()) {
            throw new LjtIllegalStateException("Not begun transaction. (not allowed local transaction)");
        }
        ConnectionWrapper wrapper = this.getConnectionTxActivePool(tx);
        if (wrapper != null) {
            if (this.isInternalDebug()) {
                logger.debug("...Checking out logical connection from pool: {}", (Object)tx);
            }
            wrapper.saveCheckOutHistory();
            return wrapper;
        }
        long wait = this.maxWait;
        while (this.getMaxPoolSize() > 0 && this.getActivePoolSize() + this.getTxActivePoolSize() >= this.getMaxPoolSize()) {
            if (wait == 0L) {
                this.throwConnectionPoolShortFreeException();
            }
            long startTime = System.currentTimeMillis();
            try {
                this.wait(this.maxWait == -1L ? 0L : wait);
            }
            catch (InterruptedException e) {
                throw new LjtSQLException("Cannot wait the connection back to pool", e);
            }
            long elapseTime = System.currentTimeMillis() - startTime;
            if (wait <= 0L) continue;
            wait -= Math.min(wait, elapseTime);
        }
        wrapper = this.checkOutFreePool(tx);
        if (wrapper == null) {
            wrapper = this.createConnection(tx);
        }
        if (tx == null) {
            this.setConnectionActivePool(wrapper);
        } else {
            LjtTransactionUtil.enlistResource(tx, wrapper.getXAResource());
            LjtTransactionUtil.registerSynchronization(tx, this.createSynchronizationImpl(tx));
            this.setConnectionTxActivePool(tx, wrapper);
        }
        wrapper.setReadOnly(this.readOnly);
        if (this.transactionIsolationLevel != -1) {
            wrapper.setTransactionIsolation(this.transactionIsolationLevel);
        }
        if (this.isInternalDebug()) {
            logger.debug("...Checking out logical connection from pool: {}", (Object)tx);
        }
        wrapper.saveCheckOutHistory();
        return wrapper;
    }

    protected Transaction getTransaction() {
        return LjtTransactionManagerUtil.getTransaction(this.transactionManager);
    }

    protected ConnectionWrapper getConnectionTxActivePool(Transaction tx) {
        return this.txActivePool.get(tx);
    }

    protected ConnectionWrapper checkOutFreePool(Transaction tx) {
        if (this.freePool.isEmpty()) {
            return null;
        }
        FreeItem item = (FreeItem)this.freePool.removeLast();
        ConnectionWrapper wrapper = item.getConnection();
        wrapper.init(tx);
        item.destroy();
        if (this.validationQuery == null || this.validationQuery.isEmpty()) {
            return wrapper;
        }
        if (this.validateConnection(wrapper, item.getPooledTime())) {
            return wrapper;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateConnection(ConnectionWrapper wrapper, long pooledTime) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - pooledTime < this.validationInterval) {
            return true;
        }
        try (PreparedStatement ps = wrapper.prepareStatement(this.validationQuery);){
            ps.executeQuery();
        }
        catch (Exception e) {
            try {
                wrapper.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (LjtLinkedList.Entry entry = this.freePool.getFirstEntry(); entry != null; entry = entry.getNext()) {
                FreeItem item = (FreeItem)entry.getElement();
                try {
                    item.getConnection().closeReally();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.freePool.clear();
            logger.info("*Destroyed the pooled connections because validation error: " + pooledTime, (Throwable)e);
            return false;
        }
        return true;
    }

    protected ConnectionWrapper createConnection(Transaction tx) throws SQLException {
        XAConnection xaConn = this.xaDataSource.getXAConnection();
        Connection conn = xaConn.getConnection();
        ConnectionWrapper wrapper = this.createTransactionalConnectionWrapper(xaConn, conn, tx);
        if (logger.isDebugEnabled()) {
            logger.debug("Created physical connection: tx={}, conn={}", (Object)tx, (Object)conn);
        }
        return wrapper;
    }

    protected ConnectionWrapper createTransactionalConnectionWrapper(XAConnection xaConnection, Connection conn, Transaction tx) throws SQLException {
        return this.createConnectionWrapper(xaConnection, conn, this, tx);
    }

    protected void setConnectionActivePool(ConnectionWrapper connection) {
        this.activePool.add(connection);
    }

    protected SynchronizationImpl createSynchronizationImpl(Transaction tx) {
        return new SynchronizationImpl(tx);
    }

    protected void setConnectionTxActivePool(Transaction tx, ConnectionWrapper wrapper) {
        this.txActivePool.put(tx, wrapper);
    }

    @Override
    public synchronized void checkIn(ConnectionWrapper wrapper) {
        this.activePool.remove(wrapper);
        this.checkInFreePool(wrapper);
    }

    @Override
    public synchronized void checkInTx(Transaction tx) {
        if (tx == null) {
            return;
        }
        if (this.getTransaction() != null) {
            return;
        }
        ConnectionWrapper wrapper = this.txActivePool.remove(tx);
        if (wrapper == null) {
            return;
        }
        this.checkInFreePool(wrapper);
    }

    protected void checkInFreePool(ConnectionWrapper wrapper) {
        wrapper.saveCheckInHistory();
        if (this.getMaxPoolSize() > 0) {
            try {
                Connection physicalConn = wrapper.getPhysicalConnection();
                physicalConn.setAutoCommit(true);
                ConnectionWrapper inheriting = this.createInheritingConnectionWrapper(wrapper, physicalConn);
                wrapper.cleanup();
                this.freePool.addLast(new FreeItem(inheriting));
                this.notify();
            }
            catch (SQLException e) {
                throw new LjtRuntimeException("Failed to check in the free pool: " + wrapper, e);
            }
        } else {
            wrapper.closeReally();
        }
    }

    protected ConnectionWrapper createInheritingConnectionWrapper(ConnectionWrapper wrapper, Connection pc) throws SQLException {
        ConnectionWrapper inheriting = this.createConnectionWrapper(wrapper.getXAConnection(), pc, this, null);
        inheriting.inheritHistory(wrapper);
        return inheriting;
    }

    @Override
    public synchronized void release(ConnectionWrapper wrapper) {
        this.activePool.remove(wrapper);
        Transaction tx = this.getTransaction();
        if (tx != null) {
            this.txActivePool.remove(tx);
        }
        wrapper.closeReally();
        this.notify();
    }

    @Override
    @PreDestroy
    public synchronized void close() {
        for (LjtLinkedList.Entry entry = this.freePool.getFirstEntry(); entry != null; entry = entry.getNext()) {
            FreeItem item = (FreeItem)entry.getElement();
            item.getConnection().closeReally();
            item.destroy();
        }
        this.freePool.clear();
        for (ConnectionWrapper wrapper : this.txActivePool.values()) {
            wrapper.closeReally();
        }
        this.txActivePool.clear();
        for (ConnectionWrapper wrapper : this.activePool) {
            wrapper.closeReally();
        }
        this.activePool.clear();
        this.timeoutTask.cancel();
    }

    protected ConnectionWrapper createConnectionWrapper(XAConnection xaConnection, Connection physicalConnection, ConnectionPool connectionPool, Transaction tx) throws SQLException {
        return new ConnectionWrapperImpl(xaConnection, physicalConnection, connectionPool, tx);
    }

    protected boolean isInternalDebug() {
        return LastaDiProperties.getInstance().isInternalDebug();
    }

    /*
     * WARNING - void declaration
     */
    protected void throwConnectionPoolShortFreeException() throws SQLException {
        void var3_8;
        LjtExceptionMessageBuilder br = new LjtExceptionMessageBuilder();
        br.addNotice("Connection pool did not have a free connection.");
        br.addItem("Pool Settings");
        br.addElement("maxPoolSize: " + this.maxPoolSize);
        br.addElement("minPoolSize: " + this.minPoolSize);
        br.addElement("maxWait: " + this.maxWait);
        br.addElement("timeout: " + this.timeout);
        br.addItem("Plain ActivePool");
        br.addElement("size: " + this.activePool.size());
        for (ConnectionWrapper connectionWrapper : this.activePool) {
            br.addElement(connectionWrapper.toTraceableView());
        }
        br.addItem("Transaction ActivePool");
        br.addElement("size: " + this.txActivePool.size());
        for (ConnectionWrapper connectionWrapper : this.txActivePool.values()) {
            br.addElement(connectionWrapper.toTraceableView());
        }
        List<String> expList = this.extractActiveTransactionExpList();
        for (String exp : expList) {
            br.addElement(exp);
        }
        br.addItem("FreePool");
        br.addElement("size: " + this.freePool.size());
        boolean bl = false;
        while (var3_8 < this.freePool.size()) {
            br.addElement(this.freePool.get((int)var3_8));
            ++var3_8;
        }
        String string = br.buildExceptionMessage();
        throw new ConnectionPoolShortFreeSQLException(string);
    }

    public synchronized List<String> extractActiveTransactionExpList() {
        ArrayList<String> expList = new ArrayList<String>(this.txActivePool.size());
        for (Map.Entry<Transaction, ConnectionWrapper> entry : this.txActivePool.entrySet()) {
            Transaction tx = entry.getKey();
            ConnectionWrapper wrapper = entry.getValue();
            String romantic = this.buildRomanticExp(tx, wrapper);
            expList.add(romantic);
        }
        return expList;
    }

    protected String buildRomanticExp(Transaction tx, ConnectionWrapper wrapper) {
        return tx.toString();
    }

    public XADataSource getXADataSource() {
        return this.xaDataSource;
    }

    public void setXADataSource(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isSuppressLocalTx() {
        return this.suppressLocalTx;
    }

    public void setSuppressLocalTx(boolean suppressLocalTx) {
        this.suppressLocalTx = suppressLocalTx;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public long getValidationInterval() {
        return this.validationInterval;
    }

    public void setValidationInterval(long validationInterval) {
        this.validationInterval = validationInterval;
    }

    @Override
    public int getActivePoolSize() {
        return this.activePool.size();
    }

    @Override
    public int getTxActivePoolSize() {
        return this.txActivePool.size();
    }

    @Override
    public int getFreePoolSize() {
        return this.freePool.size();
    }

    public class SynchronizationImpl
    implements Synchronization {
        protected final Transaction tx;

        public SynchronizationImpl(Transaction tx) {
            this.tx = tx;
        }

        public final void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            switch (status) {
                case 3: 
                case 4: {
                    SimpleConnectionPool.this.checkInTx(this.tx);
                }
            }
        }
    }

    protected class FreeItem
    implements LjtTimeoutTarget {
        protected ConnectionWrapper connectionWrapper_;
        protected LjtTimeoutTask timeoutTask_;
        protected long pooledTime;

        protected FreeItem(ConnectionWrapper connectionWrapper) {
            this.connectionWrapper_ = connectionWrapper;
            this.timeoutTask_ = LjtTimeoutManager.getInstance().addTimeoutTarget(this, SimpleConnectionPool.this.timeout, false);
            this.pooledTime = System.currentTimeMillis();
        }

        public ConnectionWrapper getConnection() {
            return this.connectionWrapper_;
        }

        public long getPooledTime() {
            return this.pooledTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void expired() {
            Object object = SimpleConnectionPool.this;
            synchronized (object) {
                if (SimpleConnectionPool.this.freePool.size() <= SimpleConnectionPool.this.minPoolSize) {
                    return;
                }
                SimpleConnectionPool.this.freePool.remove(this);
            }
            object = this;
            synchronized (object) {
                if (this.connectionWrapper_ != null) {
                    this.connectionWrapper_.closeReally();
                    this.connectionWrapper_ = null;
                }
            }
        }

        public synchronized void destroy() {
            if (this.timeoutTask_ != null) {
                this.timeoutTask_.cancel();
                this.timeoutTask_ = null;
            }
            this.connectionWrapper_ = null;
        }
    }
}

