/*
 * Copyright 2015-2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.lastaflute.di.core.exception;

/**
 * @author jflute
 */
public class ComponentPropertyNotFoundException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    protected final Class<?> targetClass;
    protected final String propertyName;

    public ComponentPropertyNotFoundException(String msg, Class<?> componentClass, String propertyName) {
        super(msg);
        this.targetClass = componentClass;
        this.propertyName = propertyName;
    }

    public Class<?> getTargetClass() {
        return targetClass;
    }

    public String getPropertyName() {
        return propertyName;
    }
}