/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.lastaflute.di.exception.IORuntimeException;

public class LdiInputStreamUtil {
    public static void close(InputStream is) throws IORuntimeException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void closeSilently(InputStream is) throws IORuntimeException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final byte[] getBytes(InputStream is) throws IORuntimeException {
        byte[] bytes = null;
        byte[] buf = new byte[8192];
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, n);
            }
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (is != null) {
                LdiInputStreamUtil.close(is);
            }
        }
        return bytes;
    }

    public static final void copy(InputStream is, OutputStream os) throws IORuntimeException {
        byte[] buf = new byte[8192];
        try {
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) != -1) {
                os.write(buf, 0, n);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static int available(InputStream is) throws IORuntimeException {
        try {
            return is.available();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void reset(InputStream is) throws IORuntimeException {
        try {
            is.reset();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

