/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.dbcp.impl;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.lastaflute.di.core.LastaDiProperties;
import org.lastaflute.jta.dbcp.ConnectionPool;
import org.lastaflute.jta.dbcp.ConnectionWrapper;
import org.lastaflute.jta.dbcp.impl.PreparedStatementWrapper;
import org.lastaflute.jta.dbcp.impl.XAResourceWrapperImpl;
import org.lastaflute.jta.exception.LjtSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionWrapperImpl
implements ConnectionWrapper,
ConnectionEventListener {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionWrapperImpl.class);
    protected XAConnection xaConnection;
    protected Connection physicalConnection;
    protected XAResource xaResource;
    protected ConnectionPool connectionPool;
    protected boolean closed = false;
    protected Transaction tx;

    public ConnectionWrapperImpl(XAConnection xaConnection, Connection physicalConnection, ConnectionPool connectionPool, Transaction tx) throws SQLException {
        this.xaConnection = xaConnection;
        this.physicalConnection = physicalConnection;
        this.xaResource = new XAResourceWrapperImpl(xaConnection.getXAResource(), this);
        this.connectionPool = connectionPool;
        this.tx = tx;
        this.xaConnection.addConnectionEventListener(this);
    }

    @Override
    public void init(Transaction tx) {
        this.closed = false;
        this.tx = tx;
    }

    @Override
    public Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    @Override
    public XAResource getXAResource() {
        return this.xaResource;
    }

    @Override
    public XAConnection getXAConnection() {
        return this.xaConnection;
    }

    @Override
    public void cleanup() {
        this.xaConnection.removeConnectionEventListener(this);
        this.closed = true;
        this.xaConnection = null;
        this.physicalConnection = null;
        this.tx = null;
    }

    @Override
    public void closeReally() {
        block15: {
            if (this.xaConnection == null) {
                return;
            }
            this.closed = true;
            try {
                if (this.physicalConnection.isClosed()) break block15;
                if (!this.physicalConnection.getAutoCommit()) {
                    try {
                        this.physicalConnection.rollback();
                        this.physicalConnection.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        logger.info("Failed to roll-back physical connection when closing really: " + this.physicalConnection, (Throwable)e);
                    }
                }
                this.physicalConnection.close();
            }
            catch (SQLException e) {
                logger.info("Failed to close physical connection when closing really: " + this.physicalConnection, (Throwable)e);
            }
            finally {
                this.physicalConnection = null;
            }
        }
        try {
            this.xaConnection.close();
            if (logger.isDebugEnabled()) {
                String view = this.toTraceableView();
                StringBuilder sb = new StringBuilder();
                sb.append("Closed the physical connection: ").append(view.contains("\n") ? "\n" : "").append(view);
                logger.debug(sb.toString());
            }
        }
        catch (SQLException e) {
            logger.info("Failed to close XA connection when closing really: " + this.xaConnection, (Throwable)e);
        }
        finally {
            this.xaConnection = null;
        }
    }

    protected void assertOpened() throws SQLException {
        if (this.closed) {
            throw new LjtSQLException(this.buildAlreadyClosedMessage());
        }
    }

    protected String buildAlreadyClosedMessage() {
        return "Already closed the connection: " + this.xaConnection;
    }

    protected void assertLocalTx() throws SQLException {
        if (this.tx != null) {
            throw new LjtSQLException("Cannot use when distributed transaction: " + this.tx);
        }
    }

    @Override
    public void release() throws SQLException {
        if (!this.closed) {
            this.connectionPool.release(this);
        }
    }

    @Override
    public void saveCheckOutHistory() {
    }

    @Override
    public void saveCheckInHistory() {
    }

    @Override
    public void inheritHistory(ConnectionWrapper wrapper) {
    }

    @Override
    public String toTraceableView() {
        return this.toString();
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        try {
            this.release();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.createStatement();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection.prepareStatement(sql), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.prepareCall(sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.nativeSQL(sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.getMetaData();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection.setReadOnly(readOnly);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.isReadOnly();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection.setCatalog(catalog);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.getCatalog();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (LastaDiProperties.getInstance().isInternalDebug() && logger.isDebugEnabled()) {
            logger.debug("#internal_debug Closed the logical connection: {}", (Object)this.xaConnection);
        }
        if (this.tx == null) {
            this.connectionPool.checkIn(this);
        } else {
            this.connectionPool.checkInTx(this.tx);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection.setTransactionIsolation(level);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.getTransactionIsolation();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.getWarnings();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection.clearWarnings();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection.commit();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection.rollback();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.assertOpened();
        if (autoCommit) {
            this.assertLocalTx();
        }
        try {
            this.physicalConnection.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.getAutoCommit();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.getTypeMap();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection.setTypeMap(map);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection.setHoldability(holdability);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.getHoldability();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            return this.physicalConnection.setSavepoint();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            return this.physicalConnection.setSavepoint(name);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection.rollback(savepoint);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection.prepareStatement(sql, autoGeneratedKeys), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection.prepareStatement(sql, columnIndexes), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection.prepareStatement(sql, columnNames), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    private SQLException wrapException(SQLException e, String sql) {
        return new LjtSQLException("Failed to execute the SQL: " + sql, e.getSQLState(), e.getErrorCode(), e);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    public Object unwrap(Class iface) throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new IllegalStateException("Not implemented yet");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(":{").append(this.closed ? "closed" : "open");
        sb.append(", ").append(this.xaConnection);
        sb.append("}@").append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    protected String buildSupplementInfoToString() {
        return "";
    }
}

