/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.intertype;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lastaflute.di.core.aop.intertype.AbstractInterType;
import org.lastaflute.di.core.aop.intertype.TigerPropertyAnnotationHandler;
import org.lastaflute.di.helper.log.LaLogger;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class PropertyInterType
extends AbstractInterType {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    protected static final int NONE = 0;
    protected static final int READ = 1;
    protected static final int WRITE = 2;
    protected static final int READWRITE = 3;
    protected static final String STR_NONE = "none";
    protected static final String STR_READ = "read";
    protected static final String STR_WRITE = "write";
    protected static final String STR_READWRITE = "readwrite";
    private static LaLogger logger = LaLogger.getLogger(PropertyInterType.class);
    private static PropertyAnnotationHandler annotationHandler = new DefaultPropertyAnnotationHandler();
    private int defaultPropertyType = 3;

    protected static int valueOf(String type) {
        int propertyType = 0;
        if (STR_READ.equals(type)) {
            propertyType = 1;
        } else if (STR_WRITE.equals(type)) {
            propertyType = 2;
        } else if (STR_READWRITE.equals(type)) {
            propertyType = 3;
        }
        return propertyType;
    }

    private static void setupAnnotationHandler() {
        annotationHandler = (PropertyAnnotationHandler)LdiClassUtil.newInstance(TigerPropertyAnnotationHandler.class);
    }

    public void setDefaultPropertyType(String defaultPropertyType) {
        this.defaultPropertyType = PropertyInterType.valueOf(defaultPropertyType);
    }

    @Override
    protected void introduce() {
        if (logger.isDebugEnabled()) {
            logger.debug("[PropertyInterType] Introducing... " + this.targetClass.getName());
        }
        int defaultValue = annotationHandler.getPropertyType(this.getTargetClass(), this.defaultPropertyType);
        List<Field> targetFields = this.getTargetFields(this.targetClass);
        for (Field field : targetFields) {
            int property = annotationHandler.getPropertyType(field, defaultValue);
            switch (property) {
                case 1: {
                    this.createGetter(this.targetClass, field);
                    break;
                }
                case 2: {
                    this.createSetter(this.targetClass, field);
                    break;
                }
                case 3: {
                    this.createGetter(this.targetClass, field);
                    this.createSetter(this.targetClass, field);
                    break;
                }
            }
        }
    }

    private void createGetter(Class<?> targetClass, Field targetField) {
        String targetFieldName = targetField.getName();
        String methodName = GETTER_PREFIX + this.createMethodName(targetFieldName);
        if (this.hasMethod(methodName, null)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[PropertyInterType] Creating getter " + targetClass.getName() + "#" + methodName);
        }
        StringBuffer src = new StringBuffer(512);
        src.append("{");
        src.append("return this.");
        src.append(targetFieldName);
        src.append(";}");
        this.addMethod(targetField.getType(), methodName, src.toString());
    }

    private void createSetter(Class<?> targetClass, Field targetField) {
        String targetFieldName = targetField.getName();
        String methodName = SETTER_PREFIX + this.createMethodName(targetFieldName);
        if (this.hasMethod(methodName, targetField.getType())) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[PropertyInterType] Creating setter " + targetClass.getName() + "#" + methodName);
        }
        StringBuffer src = new StringBuffer(512);
        src.append("{");
        src.append("this.");
        src.append(targetFieldName);
        src.append(" = $1;}");
        this.addMethod(methodName, new Class[]{targetField.getType()}, src.toString());
    }

    private List<Field> getTargetFields(Class<?> targetClass) {
        LinkedHashMap<String, Field> nominationFields = new LinkedHashMap<String, Field>();
        this.gatherFields(targetClass, nominationFields);
        ArrayList<Field> targetFields = new ArrayList<Field>(nominationFields.size());
        for (Field field : nominationFields.values()) {
            int modifier = field.getModifiers();
            if (Modifier.isPrivate(modifier)) continue;
            targetFields.add(field);
        }
        return targetFields;
    }

    private void gatherFields(Class<?> targetClass, Map<String, Field> fields) {
        Field[] declaredFields = targetClass.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            Field field = declaredFields[i];
            String name = field.getName();
            if (fields.containsKey(name)) continue;
            fields.put(name, field);
        }
        Class<?> superClass = targetClass.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            this.gatherFields(superClass, fields);
        }
    }

    private String createMethodName(String fieldName) {
        String methodName = LdiStringUtil.capitalize(fieldName);
        if (methodName.endsWith("_")) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        return methodName;
    }

    private boolean hasMethod(String methodName, Class<?> paramType) {
        Class[] param = null;
        if (paramType != null) {
            param = new Class[]{paramType};
        }
        try {
            this.getTargetClass().getMethod(methodName, param);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static {
        PropertyInterType.setupAnnotationHandler();
    }

    public static class DefaultPropertyAnnotationHandler
    implements PropertyAnnotationHandler {
        @Override
        public int getPropertyType(Class<?> clazz, int defaultValue) {
            return defaultValue;
        }

        @Override
        public int getPropertyType(Field field, int defaultValue) {
            return defaultValue;
        }
    }

    public static interface PropertyAnnotationHandler {
        public int getPropertyType(Class<?> var1, int var2);

        public int getPropertyType(Field var1, int var2);
    }
}

