/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.assembler;

import java.lang.reflect.Constructor;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.assembler.AbstractConstructorAssembler;
import org.lastaflute.di.core.util.BindingUtil;
import org.lastaflute.di.util.LdiConstructorUtil;

public class AutoConstructorAssembler
extends AbstractConstructorAssembler {
    public AutoConstructorAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    @Override
    protected Object doAssemble() {
        Constructor<?> constructor = this.getSuitableConstructor();
        if (constructor == null) {
            return this.assembleDefault();
        }
        Object[] args = this.getArgs(constructor.getParameterTypes());
        return LdiConstructorUtil.newInstance(constructor, args);
    }

    protected Constructor<?> getSuitableConstructor() {
        Constructor<?>[] constructors = this.getComponentDef().getConcreteClass().getConstructors();
        Constructor<?> constructor = null;
        int argSize = -1;
        for (int i = 0; i < constructors.length; ++i) {
            int tempArgSize = constructors[i].getParameterTypes().length;
            if (tempArgSize == 0) {
                return null;
            }
            if (tempArgSize <= argSize || !BindingUtil.isPropertyAutoBindable(constructors[i].getParameterTypes())) continue;
            constructor = constructors[i];
            argSize = tempArgSize;
        }
        return constructor;
    }
}

