/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.beans.factory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.lastaflute.di.helper.beans.ParameterizedClassDesc;
import org.lastaflute.di.helper.beans.factory.ParameterizedClassDescFactory;
import org.lastaflute.di.helper.beans.impl.ParameterizedClassDescImpl;
import org.lastaflute.di.util.tiger.LdiGenericUtil;

public class ParameterizedClassDescFactoryProvider
implements ParameterizedClassDescFactory.Provider {
    @Override
    public Map<TypeVariable<?>, Type> getTypeVariables(Class<?> beanClass) {
        return LdiGenericUtil.getTypeVariableMap(beanClass);
    }

    @Override
    public ParameterizedClassDesc createParameterizedClassDesc(Field field, Map<TypeVariable<?>, Type> map) {
        return this.createParameterizedClassDesc(field.getGenericType(), map);
    }

    @Override
    public ParameterizedClassDesc createParameterizedClassDesc(Method method, int index, Map<TypeVariable<?>, Type> map) {
        return this.createParameterizedClassDesc(method.getGenericParameterTypes()[index], map);
    }

    @Override
    public ParameterizedClassDesc createParameterizedClassDesc(Method method, Map<TypeVariable<?>, Type> map) {
        return this.createParameterizedClassDesc(method.getGenericReturnType(), map);
    }

    public ParameterizedClassDesc createParameterizedClassDesc(Type type, Map<TypeVariable<?>, Type> map) {
        Class<?> rowClass = LdiGenericUtil.getActualClass(type, map);
        if (rowClass == null) {
            return null;
        }
        Type[] parameterTypes = LdiGenericUtil.getGenericParameterTypes(type);
        if (parameterTypes == null || parameterTypes.length == 0) {
            return new ParameterizedClassDescImpl(type, rowClass);
        }
        ParameterizedClassDesc[] parameterDescs = new ParameterizedClassDesc[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterDescs[i] = this.createParameterizedClassDesc(parameterTypes[i], map);
        }
        return new ParameterizedClassDescImpl(type, rowClass, parameterDescs);
    }
}

