/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.exception.SIllegalArgumentException;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.ParameterizedClassDesc;
import org.lastaflute.di.helper.beans.PropertyDesc;
import org.lastaflute.di.helper.beans.exception.BeanIllegalPropertyException;
import org.lastaflute.di.helper.beans.factory.ParameterizedClassDescFactory;
import org.lastaflute.di.helper.beans.impl.BeanDescImpl;
import org.lastaflute.di.util.LdiBooleanConversionUtil;
import org.lastaflute.di.util.LdiCalendarConversionUtil;
import org.lastaflute.di.util.LdiConstructorUtil;
import org.lastaflute.di.util.LdiDateConversionUtil;
import org.lastaflute.di.util.LdiFieldUtil;
import org.lastaflute.di.util.LdiMethodUtil;
import org.lastaflute.di.util.LdiModifierUtil;
import org.lastaflute.di.util.LdiNumberConversionUtil;
import org.lastaflute.di.util.LdiSqlDateConversionUtil;
import org.lastaflute.di.util.LdiTimeConversionUtil;
import org.lastaflute.di.util.LdiTimestampConversionUtil;

public class PropertyDescImpl
implements PropertyDesc {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private String propertyName;
    private Class<?> propertyType;
    private Method readMethod;
    private Method writeMethod;
    private Field field;
    private BeanDesc beanDesc;
    private Constructor<?> stringConstructor;
    private Method valueOfMethod;
    private boolean readable = false;
    private boolean writable = false;
    private ParameterizedClassDesc parameterizedClassDesc;

    public PropertyDescImpl(String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, BeanDesc beanDesc) {
        this(propertyName, propertyType, readMethod, writeMethod, null, beanDesc);
    }

    public PropertyDescImpl(String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, Field field, BeanDesc beanDesc) {
        if (propertyName == null) {
            throw new EmptyRuntimeException("propertyName");
        }
        if (propertyType == null) {
            throw new EmptyRuntimeException("propertyType");
        }
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.setReadMethod(readMethod);
        this.setWriteMethod(writeMethod);
        this.setField(field);
        this.beanDesc = beanDesc;
        this.setupStringConstructor();
        this.setupValueOfMethod();
        this.setUpParameterizedClassDesc();
    }

    private void setupStringConstructor() {
        Constructor<?>[] cons = this.propertyType.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            Constructor<?> con = cons[i];
            if (con.getParameterTypes().length != 1 || !con.getParameterTypes()[0].equals(String.class)) continue;
            this.stringConstructor = con;
            break;
        }
    }

    private void setupValueOfMethod() {
        Method[] methods = this.propertyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (LdiMethodUtil.isBridgeMethod(method) || LdiMethodUtil.isSyntheticMethod(method) || !LdiModifierUtil.isStatic(method.getModifiers()) || !method.getName().equals("valueOf") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
            this.valueOfMethod = method;
            break;
        }
    }

    private void setUpParameterizedClassDesc() {
        Map<TypeVariable<?>, Type> typeVariables = ((BeanDescImpl)this.beanDesc).getTypeVariables();
        if (this.field != null) {
            this.parameterizedClassDesc = ParameterizedClassDescFactory.createParameterizedClassDesc(this.field, typeVariables);
        } else if (this.readMethod != null) {
            this.parameterizedClassDesc = ParameterizedClassDescFactory.createParameterizedClassDesc(this.readMethod, typeVariables);
        } else if (this.writeMethod != null) {
            this.parameterizedClassDesc = ParameterizedClassDescFactory.createParameterizedClassDesc(this.writeMethod, 0, typeVariables);
        }
    }

    @Override
    public final String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public final Class<?> getPropertyType() {
        return this.propertyType;
    }

    @Override
    public final Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public final void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
        if (readMethod != null) {
            this.readable = true;
            readMethod.setAccessible(true);
        }
    }

    @Override
    public final boolean hasReadMethod() {
        return this.readMethod != null;
    }

    @Override
    public final Method getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public final void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
        if (writeMethod != null) {
            this.writable = true;
            writeMethod.setAccessible(true);
        }
    }

    @Override
    public final boolean hasWriteMethod() {
        return this.writeMethod != null;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public void setField(Field field) {
        this.field = field;
        if (field != null && LdiModifierUtil.isPublic(field)) {
            this.readable = true;
            this.writable = !LdiModifierUtil.isFinal(field);
        }
    }

    @Override
    public boolean isReadable() {
        return this.readable;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public final Object getValue(Object target) {
        try {
            if (!this.readable) {
                throw new IllegalStateException(this.propertyName + " is not readable.");
            }
            if (this.hasReadMethod()) {
                return LdiMethodUtil.invoke(this.readMethod, target, EMPTY_ARGS);
            }
            return LdiFieldUtil.get(this.field, target);
        }
        catch (Throwable t) {
            throw new BeanIllegalPropertyException(this.beanDesc.getBeanClass(), this.propertyName, t);
        }
    }

    @Override
    public final void setValue(Object target, Object value) {
        block6: {
            try {
                value = this.convertIfNeed(value);
                if (!this.writable) {
                    throw new IllegalStateException(this.propertyName + " is not writable.");
                }
                if (this.hasWriteMethod()) {
                    try {
                        LdiMethodUtil.invoke(this.writeMethod, target, new Object[]{value});
                        break block6;
                    }
                    catch (Throwable t) {
                        Class<?> clazz = this.writeMethod.getDeclaringClass();
                        Class<?> valueClass = value == null ? null : value.getClass();
                        Class<?> targetClass = target == null ? null : target.getClass();
                        throw new SIllegalArgumentException("ESSR0098", new Object[]{clazz.getName(), clazz.getClassLoader(), this.propertyType.getName(), this.propertyType.getClassLoader(), this.propertyName, valueClass == null ? null : valueClass.getName(), valueClass == null ? null : valueClass.getClassLoader(), value, targetClass == null ? null : targetClass.getName(), targetClass == null ? null : targetClass.getClassLoader()}).initCause(t);
                    }
                }
                LdiFieldUtil.set(this.field, target, value);
            }
            catch (Throwable t) {
                throw new BeanIllegalPropertyException(this.beanDesc.getBeanClass(), this.propertyName, t);
            }
        }
    }

    @Override
    public BeanDesc getBeanDesc() {
        return this.beanDesc;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("property:{");
        sb.append(this.propertyName);
        sb.append(", ").append(this.propertyType.getName());
        sb.append(", reader=").append(this.readMethod != null ? this.readMethod.getName() : null);
        sb.append(", writer=").append(this.writeMethod != null ? this.writeMethod.getName() : null);
        sb.append("}@").append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    @Override
    public Object convertIfNeed(Object arg) {
        if (this.propertyType.isPrimitive()) {
            return this.convertPrimitiveWrapper(arg);
        }
        if (Number.class.isAssignableFrom(this.propertyType)) {
            return this.convertNumber(arg);
        }
        if (java.util.Date.class.isAssignableFrom(this.propertyType)) {
            return this.convertDate(arg);
        }
        if (Boolean.class.isAssignableFrom(this.propertyType)) {
            return LdiBooleanConversionUtil.toBoolean(arg);
        }
        if (arg != null && arg.getClass() != String.class && String.class == this.propertyType) {
            return arg.toString();
        }
        if (arg instanceof String && !String.class.equals(this.propertyType)) {
            return this.convertWithString(arg);
        }
        if (Calendar.class.isAssignableFrom(this.propertyType)) {
            return LdiCalendarConversionUtil.toCalendar(arg);
        }
        return arg;
    }

    private Object convertPrimitiveWrapper(Object arg) {
        return LdiNumberConversionUtil.convertPrimitiveWrapper(this.propertyType, arg);
    }

    private Object convertNumber(Object arg) {
        return LdiNumberConversionUtil.convertNumber(this.propertyType, arg);
    }

    private Object convertDate(Object arg) {
        if (this.propertyType == java.util.Date.class) {
            return LdiDateConversionUtil.toDate(arg);
        }
        if (this.propertyType == Timestamp.class) {
            return LdiTimestampConversionUtil.toTimestamp(arg);
        }
        if (this.propertyType == Date.class) {
            return LdiSqlDateConversionUtil.toDate(arg);
        }
        if (this.propertyType == Time.class) {
            return LdiTimeConversionUtil.toTime(arg);
        }
        return arg;
    }

    private Object convertWithString(Object arg) {
        if (this.stringConstructor != null) {
            return LdiConstructorUtil.newInstance(this.stringConstructor, new Object[]{arg});
        }
        if (this.valueOfMethod != null) {
            return LdiMethodUtil.invoke(this.valueOfMethod, null, new Object[]{arg});
        }
        return arg;
    }

    @Override
    public boolean isParameterized() {
        return this.parameterizedClassDesc != null && this.parameterizedClassDesc.isParameterizedClass();
    }

    @Override
    public ParameterizedClassDesc getParameterizedClassDesc() {
        return this.parameterizedClassDesc;
    }

    @Override
    public Class<?> getElementClassOfCollection() {
        if (!Collection.class.isAssignableFrom(this.propertyType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getKeyClassOfMap() {
        if (!Map.class.isAssignableFrom(this.propertyType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getValueClassOfMap() {
        if (!Map.class.isAssignableFrom(this.propertyType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[1];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }
}

