/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.message;

import java.text.MessageFormat;
import org.lastaflute.di.helper.message.MessageResourceBundle;
import org.lastaflute.di.helper.message.MessageResourceBundleFactory;

public class MessageFormatter {
    protected static final String MESSAGES = "Messages";

    protected MessageFormatter() {
    }

    public static String getMessage(String messageCode, Object[] args) {
        if (messageCode == null) {
            messageCode = "";
        }
        return MessageFormatter.getFormattedMessage(messageCode, MessageFormatter.getSimpleMessage(messageCode, args));
    }

    public static String getFormattedMessage(String messageCode, String simpleMessage) {
        return "[" + messageCode + "]" + simpleMessage;
    }

    public static String getSimpleMessage(String messageCode, Object[] arguments) {
        try {
            String pattern = MessageFormatter.getPattern(messageCode);
            if (pattern != null) {
                return MessageFormat.format(pattern, arguments);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return MessageFormatter.getNoPatternMessage(arguments);
    }

    protected static String getPattern(String messageCode) {
        String key;
        String pattern;
        MessageResourceBundle resourceBundle = MessageFormatter.getMessages(MessageFormatter.getSystemName(messageCode));
        if (resourceBundle == null) {
            return null;
        }
        int length = messageCode.length();
        if (length > 8 && (pattern = resourceBundle.get(key = messageCode.charAt(0) + messageCode.substring(length - 4))) != null) {
            return pattern;
        }
        return resourceBundle.get(messageCode);
    }

    protected static String getSystemName(String messageCode) {
        return messageCode.substring(1, Math.max(1, messageCode.length() - 4));
    }

    protected static MessageResourceBundle getMessages(String systemName) {
        return MessageResourceBundleFactory.getBundle(systemName + MESSAGES);
    }

    protected static String getNoPatternMessage(Object[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            buffer.append(args[i] + ", ");
        }
        buffer.setLength(buffer.length() - 2);
        return buffer.toString();
    }
}

