/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.lastaflute.di.exception.IORuntimeException;
import org.lastaflute.di.util.LdiFileUtil;
import org.lastaflute.di.util.LdiJarURLConnectionUtil;
import org.lastaflute.di.util.LdiURLUtil;

public class LdiJarFileUtil {
    protected LdiJarFileUtil() {
    }

    public static JarFile create(String file) {
        try {
            return new JarFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static JarFile create(File file) {
        try {
            return new JarFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream getInputStream(JarFile file, ZipEntry entry) {
        try {
            return file.getInputStream(entry);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static JarFile toJarFile(URL jarUrl) {
        URLConnection con = LdiURLUtil.openConnection(jarUrl);
        if (con instanceof JarURLConnection) {
            return LdiJarURLConnectionUtil.getJarFile((JarURLConnection)con);
        }
        return LdiJarFileUtil.create(new File(LdiJarFileUtil.toJarFilePath(jarUrl)));
    }

    public static String toJarFilePath(URL jarUrl) {
        URL nestedUrl = LdiURLUtil.create(jarUrl.getPath());
        String nestedUrlPath = nestedUrl.getPath();
        int pos = nestedUrlPath.lastIndexOf(33);
        String jarFilePath = nestedUrlPath.substring(0, pos);
        File jarFile = new File(LdiURLUtil.decode(jarFilePath, "UTF8"));
        return LdiFileUtil.getCanonicalPath(jarFile);
    }

    public static void close(JarFile jarFile) {
        try {
            jarFile.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

