/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class LdiStringUtil {
    public static final String[] EMPTY_STRINGS = new String[0];

    protected LdiStringUtil() {
    }

    public static final boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static final boolean isNotEmpty(String text) {
        return !LdiStringUtil.isEmpty(text);
    }

    public static final String replace(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(100);
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(fromText, pos2)) == 0) {
                buf.append(toText);
                pos2 = fromText.length();
                continue;
            }
            if (pos <= 0) break;
            buf.append(text.substring(pos2, pos));
            buf.append(toText);
            pos2 = pos + fromText.length();
        }
        buf.append(text.substring(pos2));
        return buf.toString();
    }

    public static String[] split(String str, String delim) {
        if (LdiStringUtil.isEmpty(str)) {
            return EMPTY_STRINGS;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreElements()) {
            list.add(st.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String ltrim(String text) {
        return LdiStringUtil.ltrim(text, null);
    }

    public static final String ltrim(String text, String trimText) {
        int pos;
        if (text == null) {
            return null;
        }
        if (trimText == null) {
            trimText = " ";
        }
        for (pos = 0; pos < text.length() && trimText.indexOf(text.charAt(pos)) >= 0; ++pos) {
        }
        return text.substring(pos);
    }

    public static final String rtrim(String text) {
        return LdiStringUtil.rtrim(text, null);
    }

    public static final String rtrim(String text, String trimText) {
        int pos;
        if (text == null) {
            return null;
        }
        if (trimText == null) {
            trimText = " ";
        }
        for (pos = text.length() - 1; pos >= 0 && trimText.indexOf(text.charAt(pos)) >= 0; --pos) {
        }
        return text.substring(0, pos + 1);
    }

    public static final String trimSuffix(String text, String suffix) {
        if (text == null) {
            return null;
        }
        if (suffix == null) {
            return text;
        }
        if (text.endsWith(suffix)) {
            return text.substring(0, text.length() - suffix.length());
        }
        return text;
    }

    public static final String trimPrefix(String text, String prefix) {
        if (text == null) {
            return null;
        }
        if (prefix == null) {
            return text;
        }
        if (text.startsWith(prefix)) {
            return text.substring(prefix.length());
        }
        return text;
    }

    public static String decapitalize(String name) {
        if (LdiStringUtil.isEmpty(name)) {
            return name;
        }
        char[] chars = name.toCharArray();
        if (chars.length >= 2 && Character.isUpperCase(chars[0]) && Character.isUpperCase(chars[1])) {
            return name;
        }
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String capitalize(String name) {
        if (LdiStringUtil.isEmpty(name)) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static boolean startsWith(String text, String fragment) {
        return LdiStringUtil.startsWithIgnoreCase(text, fragment);
    }

    public static boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !LdiStringUtil.isBlank(str);
    }

    public static boolean contains(String str, char ch) {
        if (LdiStringUtil.isEmpty(str)) {
            return false;
        }
        return str.indexOf(ch) >= 0;
    }

    public static boolean contains(String s1, String s2) {
        if (LdiStringUtil.isEmpty(s1)) {
            return false;
        }
        return s1.indexOf(s2) >= 0;
    }

    public static boolean equals(String target1, String target2) {
        return target1 == null ? target2 == null : target1.equals(target2);
    }

    public static boolean equalsIgnoreCase(String target1, String target2) {
        return target1 == null ? target2 == null : target1.equalsIgnoreCase(target2);
    }

    public static boolean endsWithIgnoreCase(String target1, String target2) {
        int length2;
        if (target1 == null || target2 == null) {
            return false;
        }
        int length1 = target1.length();
        if (length1 < (length2 = target2.length())) {
            return false;
        }
        String s1 = target1.substring(length1 - length2);
        return s1.equalsIgnoreCase(target2);
    }

    public static boolean startsWithIgnoreCase(String target1, String target2) {
        int length2;
        if (target1 == null || target2 == null) {
            return false;
        }
        int length1 = target1.length();
        if (length1 < (length2 = target2.length())) {
            return false;
        }
        String s1 = target1.substring(0, target2.length());
        return s1.equalsIgnoreCase(target2);
    }

    public static String substringFromLast(String str, String separator) {
        if (LdiStringUtil.isEmpty(str) || LdiStringUtil.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringToLast(String str, String separator) {
        if (LdiStringUtil.isEmpty(str) || LdiStringUtil.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(pos + 1, str.length());
    }

    public static String toHex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            LdiStringUtil.appendHex(sb, bytes[i]);
        }
        return sb.toString();
    }

    public static String toHex(int i) {
        StringBuffer buf = new StringBuffer();
        LdiStringUtil.appendHex(buf, i);
        return buf.toString();
    }

    public static void appendHex(StringBuffer buf, byte i) {
        buf.append(Character.forDigit((i & 0xF0) >> 4, 16));
        buf.append(Character.forDigit(i & 0xF, 16));
    }

    public static void appendHex(StringBuffer buf, int i) {
        buf.append(Integer.toHexString(i >> 24 & 0xFF));
        buf.append(Integer.toHexString(i >> 16 & 0xFF));
        buf.append(Integer.toHexString(i >> 8 & 0xFF));
        buf.append(Integer.toHexString(i & 0xFF));
    }

    public static String camelize(String s) {
        if (s == null) {
            return null;
        }
        String[] array = LdiStringUtil.split(s = s.toLowerCase(), "_");
        if (array.length == 1) {
            return LdiStringUtil.capitalize(s);
        }
        StringBuffer buf = new StringBuffer(40);
        for (int i = 0; i < array.length; ++i) {
            buf.append(LdiStringUtil.capitalize(array[i]));
        }
        return buf.toString();
    }

    public static String decamelize(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        StringBuffer buf = new StringBuffer(40);
        int pos = 0;
        for (int i = 1; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            if (buf.length() != 0) {
                buf.append('_');
            }
            buf.append(s.substring(pos, i).toUpperCase());
            pos = i;
        }
        if (buf.length() != 0) {
            buf.append('_');
        }
        buf.append(s.substring(pos, s.length()).toUpperCase());
        return buf.toString();
    }

    public static boolean isNumber(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char chr = s.charAt(i);
            if (chr >= '0' && '9' >= chr) continue;
            return false;
        }
        return true;
    }
}

