/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.core;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.lastaflute.jta.core.ExtendedTransaction;
import org.lastaflute.jta.exception.LjtIllegalStateException;
import org.lastaflute.jta.exception.LjtNotSupportedException;
import org.lastaflute.jta.util.LjtTransactionUtil;

public abstract class AbstractTransactionManager
implements TransactionManager {
    protected final ThreadLocal<ExtendedTransaction> threadAttachTx = new ThreadLocal();

    public void begin() throws NotSupportedException, SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx != null) {
            throw new LjtNotSupportedException("Unsupported nested transaction: current=" + tx);
        }
        tx = this.attachNewTransaction();
        tx.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx == null) {
            throw new LjtIllegalStateException("Not begun transaction for commit().");
        }
        try {
            tx.commit();
        }
        finally {
            this.setCurrent(null);
        }
    }

    public Transaction suspend() throws SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx == null) {
            throw new LjtIllegalStateException("Not begun transaction for suspend().");
        }
        try {
            tx.suspend();
        }
        finally {
            this.setCurrent(null);
        }
        return tx;
    }

    public void resume(Transaction resumeTx) throws InvalidTransactionException, IllegalStateException, SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx != null) {
            throw new LjtIllegalStateException("Already assigned the other transaction for resume().");
        }
        ((ExtendedTransaction)resumeTx).resume();
        this.setCurrent((ExtendedTransaction)resumeTx);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx == null) {
            throw new LjtIllegalStateException("Not begun transaction for rollback().");
        }
        try {
            tx.rollback();
        }
        finally {
            this.setCurrent(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ExtendedTransaction tx = this.getCurrent();
        if (tx == null) {
            throw new LjtIllegalStateException("Not begun transaction for setRollbackOnly().");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
    }

    public int getStatus() {
        ExtendedTransaction tx = this.getCurrent();
        if (tx != null) {
            return LjtTransactionUtil.getStatus(tx);
        }
        return 6;
    }

    public Transaction getTransaction() {
        return this.getCurrent();
    }

    protected ExtendedTransaction getCurrent() {
        ExtendedTransaction tx = this.threadAttachTx.get();
        if (tx != null && LjtTransactionUtil.getStatus(tx) == 6) {
            this.setCurrent(null);
            return null;
        }
        return tx;
    }

    protected void setCurrent(ExtendedTransaction current) {
        this.threadAttachTx.set(current);
    }

    protected ExtendedTransaction attachNewTransaction() {
        ExtendedTransaction tx = this.threadAttachTx.get();
        if (tx == null) {
            tx = this.createTransaction();
            this.setCurrent(tx);
        }
        return tx;
    }

    protected abstract ExtendedTransaction createTransaction();
}

