/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory;

import javax.script.ScriptEngineManager;
import org.lastaflute.di.DisposableUtil;
import org.lastaflute.di.core.ExternalContext;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.LastaDiProperties;
import org.lastaflute.di.core.external.ExternalContextComponentDefRegister;
import org.lastaflute.di.core.factory.LaContainerFactory;
import org.lastaflute.di.core.smart.SmartDeployMode;
import org.lastaflute.di.core.util.SmartDeployUtil;
import org.lastaflute.di.naming.NamingConvention;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonLaContainerFactory {
    private static final Logger logger = LoggerFactory.getLogger(SingletonLaContainerFactory.class);
    private static String configPath = "app.xml";
    private static ExternalContext externalContext;
    private static ExternalContextComponentDefRegister externalContextComponentDefRegister;
    private static LaContainer container;

    private SingletonLaContainerFactory() {
    }

    public static void init() {
        if (container != null) {
            return;
        }
        SingletonLaContainerFactory.setupScriptEngine();
        SingletonLaContainerFactory.setupSmartDeployMode();
        container = SingletonLaContainerFactory.createContainer();
        SingletonLaContainerFactory.setupExternalContext();
        container.init();
        SingletonLaContainerFactory.showBoot();
    }

    protected static void setupScriptEngine() {
        new Thread(() -> {
            Class<?> engineType = LastaDiProperties.getInstance().getDiXmlScriptExpressionEngineType();
            if (engineType == null) {
                new ScriptEngineManager().getEngineByName("javascript");
            }
        }).start();
    }

    protected static void setupSmartDeployMode() {
        String smartDeployMode = LastaDiProperties.getInstance().getSmartDeployMode();
        if (smartDeployMode != null) {
            SmartDeployMode.setValue(SmartDeployMode.codeOf(smartDeployMode));
        } else {
            logger.info("*Not found smart deploy mode property so use default mode: {}", (Object)SmartDeployMode.getValue());
        }
    }

    protected static LaContainer createContainer() {
        return LaContainerFactory.create(configPath);
    }

    protected static void setupExternalContext() {
        if (container.getExternalContext() == null) {
            if (externalContext != null) {
                container.setExternalContext(externalContext);
            }
        } else if (container.getExternalContext().getApplication() == null && externalContext != null) {
            container.getExternalContext().setApplication(externalContext.getApplication());
        }
        if (container.getExternalContextComponentDefRegister() == null && externalContextComponentDefRegister != null) {
            container.setExternalContextComponentDefRegister(externalContextComponentDefRegister);
        }
    }

    protected static void showBoot() {
        logger.info("Lasta Di boot successfully.");
        logger.info("  SmartDeploy Mode: {}", (Object)SmartDeployUtil.getDeployMode(container));
        if (SingletonLaContainerFactory.getContainer().hasComponentDef(NamingConvention.class)) {
            NamingConvention convention = (NamingConvention)SingletonLaContainerFactory.getContainer().getComponent(NamingConvention.class);
            StringBuilder sb = new StringBuilder();
            for (String rootPkg : convention.getRootPackageNames()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(rootPkg);
            }
            logger.info("  Smart Package: {}", (Object)sb.toString());
        }
    }

    public static void destroy() {
        if (container == null) {
            return;
        }
        container.destroy();
        container = null;
        DisposableUtil.dispose();
    }

    public static boolean hasContainer() {
        return container != null;
    }

    public static LaContainer getContainer() {
        if (container == null) {
            throw new IllegalStateException("Not initialized the container when getContainer().");
        }
        return container;
    }

    public static void setContainer(LaContainer ner) {
        container = ner;
    }

    public static String getConfigPath() {
        return configPath;
    }

    public static void setConfigPath(String path) {
        configPath = path;
    }

    public static ExternalContext getExternalContext() {
        return externalContext;
    }

    public static void setExternalContext(ExternalContext extCtx) {
        externalContext = extCtx;
    }

    public static ExternalContextComponentDefRegister getExternalContextComponentDefRegister() {
        return externalContextComponentDefRegister;
    }

    public static void setExternalContextComponentDefRegister(ExternalContextComponentDefRegister extCtxComponentDefRegister) {
        externalContextComponentDefRegister = extCtxComponentDefRegister;
    }
}

