/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.xml;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import org.lastaflute.di.helper.xml.SaxHandler;
import org.lastaflute.di.util.LdiResourceUtil;
import org.lastaflute.di.util.LdiSAXParserFactoryUtil;
import org.lastaflute.di.util.LdiSAXParserUtil;
import org.xml.sax.InputSource;

public class SaxHandlerParser {
    protected final SaxHandler saxHandler;
    protected final SAXParser saxParser;

    public SaxHandlerParser(SaxHandler saxHandler) {
        this(saxHandler, LdiSAXParserFactoryUtil.newSAXParser());
    }

    public SaxHandlerParser(SaxHandler saxHandler, SAXParser saxParser) {
        this.saxHandler = saxHandler;
        this.saxParser = saxParser;
    }

    public Object parse(String path) {
        return this.parse(LdiResourceUtil.getResourceAsStream(path), path);
    }

    public Object parse(InputStream inputStream) {
        return this.parse(new InputSource(inputStream));
    }

    public Object parse(InputStream inputStream, String path) {
        InputSource is = new InputSource(inputStream);
        is.setSystemId(path);
        return this.parse(is);
    }

    public Object parse(InputSource inputSource) {
        LdiSAXParserUtil.parse(this.saxParser, inputSource, this.saxHandler);
        return this.saxHandler.getResult();
    }

    public SaxHandler getSaxHandler() {
        return this.saxHandler;
    }

    public SAXParser getSAXParser() {
        return this.saxParser;
    }
}

