/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.redefiner.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.annotation.Aspect;
import org.lastaflute.di.core.assembler.AutoBindingDefFactory;
import org.lastaflute.di.core.factory.AspectDefFactory;
import org.lastaflute.di.core.factory.LaContainerFactory;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandler;
import org.lastaflute.di.core.factory.annohandler.AnnotationHandlerFactory;
import org.lastaflute.di.core.factory.conbuilder.impl.AbstractLaContainerBuilder;
import org.lastaflute.di.core.meta.AspectDef;
import org.lastaflute.di.core.meta.impl.ArgDefImpl;
import org.lastaflute.di.core.meta.impl.DestroyMethodDefImpl;
import org.lastaflute.di.core.meta.impl.InitMethodDefImpl;
import org.lastaflute.di.core.meta.impl.InstanceDefFactory;
import org.lastaflute.di.core.meta.impl.LaContainerImpl;
import org.lastaflute.di.redefiner.LaContainerPreparer;
import org.lastaflute.di.redefiner.annotation.Component;
import org.lastaflute.di.redefiner.annotation.Dicon;
import org.lastaflute.di.redefiner.util.ClassBuilderUtils;
import org.lastaflute.di.redefiner.util.CompositeClassLoader;
import org.lastaflute.di.redefiner.util.LaContainerBuilderUtils;

public class ClassS2ContainerBuilder
extends AbstractLaContainerBuilder {
    public static final String METHODPREFIX_DEFINE = "define";
    public static final String METHODPREFIX_NEW = "new";
    public static final String METHODPREFIX_DESTROY = "destroy";
    public static final String SUFFIX = ".class";
    private static final String JAR_SUFFIX = ".jar!/";
    private static final String DELIMITER = "_";

    @Override
    public LaContainer build(String path) {
        return this.build(null, path);
    }

    LaContainer build(LaContainer parent, String path) {
        LaContainerPreparer preparer;
        LaContainer container = this.createContainer(parent, path);
        Class<? extends LaContainerPreparer> preparerClass = this.getPreparerClass(path);
        try {
            preparer = preparerClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Can't instanciate Preparer: " + path, ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Can't instanciate Preparer: " + path, ex);
        }
        container.register(preparer);
        preparer.setContainer(container);
        Dicon dicon = preparerClass.getAnnotation(Dicon.class);
        if (dicon != null && dicon.namespace().length() > 0) {
            container.setNamespace(dicon.namespace());
        }
        preparer.include();
        this.registerComponentDefs(container, preparer);
        String additionalDiconPath = this.constructAdditionalDiconPath(path);
        if (LaContainerBuilderUtils.resourceExists(additionalDiconPath, this)) {
            LaContainerBuilderUtils.mergeContainer(container, LaContainerFactory.create(additionalDiconPath));
        }
        return container;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected String constructAdditionalDiconPath(String path) {
        return this.constructRedifinitionDiconPath(path, null);
    }

    LaContainer createContainer(LaContainer parent, String path) {
        LaContainerImpl container = new LaContainerImpl();
        container.setPath(path);
        if (parent != null) {
            container.setRoot(parent.getRoot());
        }
        return container;
    }

    void registerComponentDefs(LaContainer container, LaContainerPreparer preparer) {
        Method[] methods = preparer.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith(METHODPREFIX_DEFINE)) continue;
            this.registerComponentDef(container, methods[i], preparer);
        }
    }

    void registerComponentDef(LaContainer container, Method method, LaContainerPreparer preparer) {
        ComponentDef componentDef = this.constructComponentDef(method, preparer);
        if (componentDef.getComponentName() != null) {
            componentDef = this.redefine(componentDef, container.getPath());
        }
        container.register(componentDef);
    }

    ComponentDef redefine(ComponentDef componentDef, String path) {
        String name = componentDef.getComponentName();
        String diconPath = this.constructRedifinitionDiconPath(path, name);
        if (!LaContainerBuilderUtils.resourceExists(diconPath, this)) {
            return componentDef;
        }
        LaContainer container = LaContainerFactory.create(diconPath);
        if (!container.hasComponentDef(name)) {
            throw new RuntimeException("Can't find component definition named '" + name + "' in " + diconPath);
        }
        return container.getComponentDef(name);
    }

    protected String constructRedifinitionDiconPath(String path, String name) {
        String suffix;
        String body;
        int dot = path.lastIndexOf(46);
        if (dot < 0) {
            body = path;
            suffix = "";
        } else {
            body = path.substring(0, dot);
            suffix = path.substring(dot);
        }
        if (name == null) {
            name = "";
        }
        return body + DELIMITER + name + suffix;
    }

    ComponentDef constructComponentDef(Method method, LaContainerPreparer preparer) {
        Aspect aspectAnnotation;
        AnnotationHandler annoHandler = AnnotationHandlerFactory.getAnnotationHandler();
        String componentName = ClassBuilderUtils.toComponentName(method.getName().substring(METHODPREFIX_DEFINE.length()));
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new RuntimeException("Definition method must have only one parameter but " + parameterTypes.length + ": " + method.getName());
        }
        Class<?> componentClass = parameterTypes[0];
        Class[] constructorParameterTypes = new Class[parameterTypes.length - 1];
        System.arraycopy(parameterTypes, 1, constructorParameterTypes, 0, constructorParameterTypes.length);
        ComponentDef componentDef = annoHandler.createComponentDef(componentClass, null);
        componentDef.setComponentName(componentName);
        annoHandler.appendDI(componentDef);
        annoHandler.appendAspect(componentDef);
        annoHandler.appendInterType(componentDef);
        Component componentAnnotation = method.getAnnotation(Component.class);
        if (componentAnnotation != null) {
            componentDef.setInstanceDef(InstanceDefFactory.getInstanceDef(componentAnnotation.instance().getName()));
            componentDef.setAutoBindingDef(AutoBindingDefFactory.getAutoBindingDef(componentAnnotation.autoBinding().getName()));
            componentDef.setExternalBinding(componentAnnotation.externalBinding());
        }
        if ((aspectAnnotation = method.getAnnotation(Aspect.class)) != null) {
            AspectDef aspectDef = AspectDefFactory.createAspectDef(aspectAnnotation.value(), aspectAnnotation.pointcut());
            componentDef.addAspectDef(aspectDef);
        }
        annoHandler.appendInitMethod(componentDef);
        annoHandler.appendDestroyMethod(componentDef);
        InitMethodDefImpl initMethodDef = new InitMethodDefImpl(method);
        ArgDefImpl argDef = new ArgDefImpl(preparer);
        initMethodDef.addArgDef(argDef);
        componentDef.addInitMethodDef(initMethodDef);
        Method destroyMethod = ClassBuilderUtils.findMethod(preparer.getClass(), componentName, METHODPREFIX_DESTROY);
        if (destroyMethod != null) {
            DestroyMethodDefImpl destroyMethodDef = new DestroyMethodDefImpl(destroyMethod);
            argDef = new ArgDefImpl(preparer);
            destroyMethodDef.addArgDef(argDef);
            componentDef.addDestroyMethodDef(destroyMethodDef);
        }
        return componentDef;
    }

    protected Class<? extends LaContainerPreparer> getPreparerClass(String path) {
        ClassLoader classLoader = this.getClassLoaderForLoadingPreparer();
        Class<?> clazz = path.indexOf(58) < 0 ? this.getClassFromClassName(path, classLoader) : this.getClassFromURL(path, classLoader);
        if (clazz == null) {
            throw new RuntimeException("Class not found: " + path);
        }
        if (LaContainerPreparer.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new RuntimeException("Not Preparer: " + path);
    }

    protected Class<?> getClassFromURL(String path, ClassLoader classLoader) {
        String[] classNames;
        int jarSuffix = path.indexOf(JAR_SUFFIX);
        if (jarSuffix >= 0) {
            classNames = new String[]{path.substring(jarSuffix + JAR_SUFFIX.length(), path.length() - SUFFIX.length()).replace('/', '.')};
        } else {
            path = path.substring(path.indexOf(58) + 1, path.length() - SUFFIX.length()).replace('/', '.');
            ArrayList<String> classNameList = new ArrayList<String>();
            int len = path.length();
            for (int i = len - 1; i >= 0; --i) {
                if (path.charAt(i) != '.') continue;
                classNameList.add(path.substring(i + 1));
            }
            classNames = classNameList.toArray(new String[0]);
        }
        for (int i = 0; i < classNames.length; ++i) {
            try {
                return Class.forName(classNames[i], true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return null;
    }

    Class<?> getClassFromClassName(String path, ClassLoader classLoader) {
        String className = path.substring(0, path.length() - SUFFIX.length()).replace('/', '.');
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    ClassLoader getClassLoaderForLoadingPreparer() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return new CompositeClassLoader(new ClassLoader[]{classLoader, this.getClass().getClassLoader()});
    }

    @Override
    public LaContainer include(LaContainer parent, String path) {
        LaContainer child = this.build(parent, path);
        parent.include(child);
        return child;
    }
}

