/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.core;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.lastaflute.jta.core.RestrictedTransaction;

public class RestrictedTransactionManager
implements TransactionManager {
    protected final UserTransaction userTransaction;
    protected final TransactionSynchronizationRegistry synchronizationRegistry;

    public RestrictedTransactionManager(UserTransaction userTransaction, TransactionSynchronizationRegistry synchronizationRegistry) {
        this.userTransaction = userTransaction;
        this.synchronizationRegistry = synchronizationRegistry;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.userTransaction.begin();
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.userTransaction.commit();
    }

    public int getStatus() throws SystemException {
        return this.userTransaction.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        int status = this.getStatus();
        if (status == 6 || status == 5) {
            return null;
        }
        RestrictedTransaction tx = (RestrictedTransaction)this.synchronizationRegistry.getResource((Object)this);
        if (tx == null) {
            tx = new RestrictedTransaction(this.userTransaction, this.synchronizationRegistry);
            this.synchronizationRegistry.putResource((Object)this, (Object)tx);
        }
        return tx;
    }

    public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
        throw new UnsupportedOperationException("resume");
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.userTransaction.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.userTransaction.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.userTransaction.setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        throw new UnsupportedOperationException("suspend");
    }
}

